/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t=c!B\u0001\u0003\u0001\u0011Q!A\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJT!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0004%\tAG\u0001\u000fIJLg/\u001a:F]\u0012\u0004x.\u001b8u\u0007\u0001)\u0012a\u0007\t\u00039}i\u0011!\b\u0006\u0003=\u0011\t1A\u001d9d\u0013\t\u0001SD\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\u0011\t\u0002!\u00111A\u0005\u0002\r\n!\u0003\u001a:jm\u0016\u0014XI\u001c3q_&tGo\u0018\u0013fcR\u0011Ae\n\t\u0003\u0019\u0015J!AJ\u0007\u0003\tUs\u0017\u000e\u001e\u0005\bQ\u0005\n\t\u00111\u0001\u001c\u0003\rAH%\r\u0005\tU\u0001\u0011\t\u0011)Q\u00057\u0005yAM]5wKJ,e\u000e\u001a9pS:$\b\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003\u0011\u0019wN\u001c4\u0011\u00059zS\"\u0001\u0003\n\u0005A\"!!C*qCJ\\7i\u001c8g\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0014\u0001C5t\tJLg/\u001a:\u0011\u00051!\u0014BA\u001b\u000e\u0005\u001d\u0011un\u001c7fC:DQa\u000e\u0001\u0005\u0002a\na\u0001P5oSRtD\u0003B\u001d<yu\u0002\"A\u000f\u0001\u000e\u0003\tAQ\u0001\u0007\u001cA\u0002mAQ\u0001\f\u001cA\u00025BQA\r\u001cA\u0002MBqa\u0010\u0001C\u0002\u0013\u0005\u0001)A\u0004uS6,w.\u001e;\u0016\u0003\u0005\u0003\"\u0001\b\"\n\u0005\rk\"A\u0003*qGRKW.Z8vi\"1Q\t\u0001Q\u0001\n\u0005\u000b\u0001\u0002^5nK>,H\u000f\t\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u000fe\u0016lwN^3Fq\u0016\u001cW\u000f^8s)\t!\u0013\nC\u0003K\r\u0002\u00071*\u0001\u0004fq\u0016\u001c\u0017\n\u001a\t\u0003\u0019Ns!!T)\u0011\u00059kQ\"A(\u000b\u0005AK\u0012A\u0002\u001fs_>$h(\u0003\u0002S\u001b\u00051\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011V\u0002C\u0003X\u0001\u0011\u0005\u0001,A\nsK6|g/Z#yK\u000e,Ho\u001c:Bgft7\r\u0006\u0002%3\")!J\u0016a\u0001\u0017\")1\f\u0001C\u00019\u0006!\"/Z4jgR,'O\u00117pG.l\u0015M\\1hKJ$R!\u00181cO&\u0004\"A\u000f0\n\u0005}\u0013!A\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\u0005\u0006Cj\u0003\r!X\u0001\u000fE2|7m['b]\u0006<WM]%e\u0011\u0015\u0019'\f1\u0001e\u0003Ai\u0017\r_(o\u0011\u0016\f\u0007/T3n'&TX\r\u0005\u0002\rK&\u0011a-\u0004\u0002\u0005\u0019>tw\rC\u0003i5\u0002\u0007A-A\tnCb|eM\u001a%fCBlU-\\*ju\u0016DQA\u001b.A\u0002m\tQb\u001d7bm\u0016,e\u000e\u001a9pS:$\b\"\u00027\u0001\t\u0003i\u0017aD;qI\u0006$XM\u00117pG.LeNZ8\u0015\rMrw\u000e^=|\u0011\u0015\t7\u000e1\u0001^\u0011\u0015\u00018\u000e1\u0001r\u0003\u001d\u0011Gn\\2l\u0013\u0012\u0004\"A\u000f:\n\u0005M\u0014!a\u0002\"m_\u000e\\\u0017\n\u001a\u0005\u0006k.\u0004\rA^\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0003u]L!\u0001\u001f\u0002\u0003\u0019M#xN]1hK2+g/\u001a7\t\u000bi\\\u0007\u0019\u00013\u0002\u000f5,WnU5{K\")Ap\u001ba\u0001I\u0006AA-[:l'&TX\rC\u0003\u007f\u0001\u0011\u0005q0\u0001\u0007hKRdunY1uS>t7\u000f\u0006\u0003\u0002\u0002\u0005M\u0001#BA\u0002\u0003\u001bif\u0002BA\u0003\u0003\u0013q1ATA\u0004\u0013\u0005q\u0011bAA\u0006\u001b\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u00111aU3r\u0015\r\tY!\u0004\u0005\u0006av\u0004\r!\u001d\u0005\b\u0003/\u0001A\u0011AA\r\u0003U9W\r\u001e'pG\u0006$\u0018n\u001c8t\u0003:$7\u000b^1ukN$B!a\u0007\u0002@A)A\"!\b\u0002\"%\u0019\u0011qD\u0007\u0003\r=\u0003H/[8o!\u0011\t\u0019#!\u000f\u000f\t\u0005\u0015\u0012Q\u0007\b\u0005\u0003O\t\u0019D\u0004\u0003\u0002*\u0005Eb\u0002BA\u0016\u0003_q1ATA\u0017\u0013\u0005I\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t%\u0019\u0011q\u0007\u0002\u0002)\tcwnY6NC:\fw-\u001a:NKN\u001c\u0018mZ3t\u0013\u0011\tY$!\u0010\u0003/\tcwnY6M_\u000e\fG/[8og\u0006sGm\u0015;biV\u001c(bAA\u001c\u0005!1\u0001/!\u0006A\u0002EDaA \u0001\u0005\u0002\u0005\rC\u0003BA#\u0003\u0017\u0002b!a\u0001\u0002H\u0005\u0005\u0011\u0002BA%\u0003#\u0011!\"\u00138eKb,GmU3r\u0011!\ti%!\u0011A\u0002\u0005=\u0013\u0001\u00032m_\u000e\\\u0017\nZ:\u0011\t1\t\t&]\u0005\u0004\u0003'j!!B!se\u0006L\bbBA,\u0001\u0011\u0005\u0011\u0011L\u0001\tG>tG/Y5ogR\u00191'a\u0017\t\rA\f)\u00061\u0001r\u0011\u001d\ty\u0006\u0001C\u0001\u0003C\n\u0001bZ3u!\u0016,'o\u001d\u000b\u0005\u0003\u0003\t\u0019\u0007\u0003\u0004b\u0003;\u0002\r!\u0018\u0005\b\u0003O\u0002A\u0011AA5\u0003Y9W\r^#yK\u000e,Ho\u001c:F]\u0012\u0004x.\u001b8u%\u00164G\u0003BA6\u0003[\u0002B\u0001DA\u000f7!9\u0011qNA3\u0001\u0004Y\u0015AC3yK\u000e,Ho\u001c:JI\"9\u00111\u000f\u0001\u0005\u0002\u0005U\u0014a\u0003:f[>4XM\u00117pG.$2\u0001JA<\u0011\u0019\u0001\u0018\u0011\u000fa\u0001c\"9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014!\u0003:f[>4XM\u00153e)\u0015!\u0013qPAE\u0011!\t\t)!\u001fA\u0002\u0005\r\u0015!\u0002:eI&#\u0007c\u0001\u0007\u0002\u0006&\u0019\u0011qQ\u0007\u0003\u0007%sG\u000fC\u0004\u0002\f\u0006e\u0004\u0019A\u001a\u0002\u0011\tdwnY6j]\u001eDq!a$\u0001\t\u0003\t\t*A\u0007sK6|g/Z*ik\u001a4G.\u001a\u000b\u0006I\u0005M\u0015q\u0013\u0005\t\u0003+\u000bi\t1\u0001\u0002\u0004\u0006I1\u000f[;gM2,\u0017\n\u001a\u0005\b\u0003\u0017\u000bi\t1\u00014\u0011\u001d\tY\n\u0001C\u0001\u0003;\u000bqB]3n_Z,'I]8bI\u000e\f7\u000f\u001e\u000b\bI\u0005}\u00151UAT\u0011\u001d\t\t+!'A\u0002\u0011\f1B\u0019:pC\u0012\u001c\u0017m\u001d;JI\"9\u0011QUAM\u0001\u0004\u0019\u0014\u0001\u0005:f[>4XM\u0012:p[6\u000b7\u000f^3s\u0011\u001d\tY)!'A\u0002MBq!a+\u0001\t\u0003\ti+A\bhKRlU-\\8ssN#\u0018\r^;t+\t\ty\u000b\u0005\u0004M\u0003ck\u0016QW\u0005\u0004\u0003g+&aA'baB)A\"a.eI&\u0019\u0011\u0011X\u0007\u0003\rQ+\b\u000f\\33\u0011\u001d\ti\f\u0001C\u0001\u0003\u007f\u000b\u0001cZ3u'R|'/Y4f'R\fG/^:\u0016\u0005\u0005\u0005\u0007#\u0002\u0007\u0002R\u0005\r\u0007c\u0001\u001e\u0002F&\u0019\u0011q\u0019\u0002\u0003\u001bM#xN]1hKN#\u0018\r^;t\u0011\u001d\tY\r\u0001C\u0001\u0003\u001b\fabZ3u\u00052|7m[*uCR,8\u000f\u0006\u0004\u0002P\u0006]\u0017\u0011\u001c\t\u0007\u0019\u0006EV,!5\u0011\u0007i\n\u0019.C\u0002\u0002V\n\u00111B\u00117pG.\u001cF/\u0019;vg\"1\u0001/!3A\u0002ED\u0011\"a7\u0002JB\u0005\t\u0019A\u001a\u0002\u0013\u0005\u001c8n\u00157bm\u0016\u001c\bbBAp\u0001\u0011\u0005\u0011\u0011]\u0001\u0014O\u0016$X*\u0019;dQ&twM\u00117pG.LEm\u001d\u000b\u0007\u0003G\f)/a<\u0011\u000b\u0005\r\u0011QB9\t\u0011\u0005\u001d\u0018Q\u001ca\u0001\u0003S\faAZ5mi\u0016\u0014\b#\u0002\u0007\u0002lF\u001c\u0014bAAw\u001b\tIa)\u001e8di&|g.\r\u0005\b\u00037\fi\u000e1\u00014\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003k\fq\u0002[1t\u0007\u0006\u001c\u0007.\u001a3CY>\u001c7n\u001d\u000b\u0004g\u0005]\bbBA8\u0003c\u0004\ra\u0013\u0005\b\u0003w\u0004A\u0011AA\u007f\u0003\u0011\u0019Ho\u001c9\u0015\u0003\u0011BqA!\u0001\u0001\t\u0013\u0011\u0019!\u0001\u0003uK2dGc\u0001\u0013\u0003\u0006!A!qAA\u0000\u0001\u0004\u0011I!A\u0004nKN\u001c\u0018mZ3\u0011\u00071\u0011Y!C\u0002\u0003\u000e5\u00111!\u00118z\u0011%\u0011\t\u0002AI\u0001\n\u0003\u0011\u0019\"\u0001\rhKR\u0014En\\2l'R\fG/^:%I\u00164\u0017-\u001e7uII*\"A!\u0006+\u0007M\u00129b\u000b\u0002\u0003\u001aA!!1\u0004B\u0013\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012!C;oG\",7m[3e\u0015\r\u0011\u0019#D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0014\u0005;\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f!\u0011YC\u0001E\u0001\t\t5\u0012A\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJ\u00042A\u000fB\u0018\r\u001d\t!\u0001#\u0001\u0005\u0005c\u00192Aa\f\f\u0011\u001d9$q\u0006C\u0001\u0005k!\"A!\f\t\u0015\te\"q\u0006b\u0001\n\u0003\u0011Y$\u0001\u000bE%&3VIU0F\u001d\u0012\u0003v*\u0013(U?:\u000bU*R\u000b\u0003\u0005{\u0001BAa\u0010\u0003J5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%\u0001\u0003mC:<'B\u0001B$\u0003\u0011Q\u0017M^1\n\u0007Q\u0013\t\u0005C\u0005\u0003N\t=\u0002\u0015!\u0003\u0003>\u0005)BIU%W\u000bJ{VI\u0014#Q\u001f&sEk\u0018(B\u001b\u0016\u0003\u0003")
public class BlockManagerMaster
implements Logging {
    private RpcEndpointRef driverEndpoint;
    private final boolean isDriver;
    private final RpcTimeout timeout;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String DRIVER_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public RpcTimeout timeout() {
        return this.timeout;
    }

    public void removeExecutor(String execId) {
        this.tell(new BlockManagerMessages.RemoveExecutor(execId));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removed ").append(execId).append(" successfully in removeExecutor").toString());
    }

    public void removeExecutorAsync(String execId) {
        this.driverEndpoint().ask(new BlockManagerMessages.RemoveExecutor(execId), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Removal of executor ").append(execId).append(" requested").toString());
    }

    public BlockManagerId registerBlockManager(BlockManagerId blockManagerId, long maxOnHeapMemSize, long maxOffHeapMemSize, RpcEndpointRef slaveEndpoint) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Registering BlockManager ").append(blockManagerId).toString());
        BlockManagerId updatedId = (BlockManagerId)this.driverEndpoint().askSync(new BlockManagerMessages.RegisterBlockManager(blockManagerId, maxOnHeapMemSize, maxOffHeapMemSize, slaveEndpoint), ClassTag$.MODULE$.apply(BlockManagerId.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Registered BlockManager ").append(updatedId).toString());
        return updatedId;
    }

    public boolean updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        boolean res = BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(new BlockManagerMessages.UpdateBlockInfo(blockManagerId, blockId, storageLevel, memSize, diskSize), ClassTag$.MODULE$.Boolean()));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Updated info of block ").append(blockId).toString());
        return res;
    }

    public Seq<BlockManagerId> getLocations(BlockId blockId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocations(blockId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<BlockManagerMessages.BlockLocationsAndStatus> getLocationsAndStatus(BlockId blockId) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsAndStatus(blockId), ClassTag$.MODULE$.apply(Option.class));
    }

    public IndexedSeq<Seq<BlockManagerId>> getLocations(BlockId[] blockIds) {
        return (IndexedSeq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsMultipleBlockIds(blockIds), ClassTag$.MODULE$.apply(IndexedSeq.class));
    }

    public boolean contains(BlockId blockId) {
        return !this.getLocations(blockId).isEmpty();
    }

    public Seq<BlockManagerId> getPeers(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetPeers(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<RpcEndpointRef> getExecutorEndpointRef(String executorId) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetExecutorEndpointRef(executorId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void removeBlock(BlockId blockId) {
        this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean());
    }

    public void removeRdd(int rddId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveRdd(rddId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Failed to remove RDD ").append(rddId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            this.timeout().awaitResult(future);
        }
    }

    public void removeShuffle(int shuffleId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveShuffle(shuffleId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Failed to remove shuffle ").append(shuffleId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            this.timeout().awaitResult(future);
        }
    }

    public void removeBroadcast(long broadcastId, boolean removeFromMaster, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromMaster), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Failed to remove broadcast ").append(broadcastId$1).append(new StringBuilder(28).append(" with removeFromMaster = ").append(removeFromMaster$1).append(" - ").append(e.getMessage()).toString()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            this.timeout().awaitResult(future);
        }
    }

    public Map<BlockManagerId, Tuple2<Object, Object>> getMemoryStatus() {
        return (Map)this.driverEndpoint().askSync(BlockManagerMessages$GetMemoryStatus$.MODULE$, ClassTag$.MODULE$.apply(Map.class));
    }

    public StorageStatus[] getStorageStatus() {
        return (StorageStatus[])this.driverEndpoint().askSync(BlockManagerMessages$GetStorageStatus$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StorageStatus.class)));
    }

    public Map<BlockManagerId, BlockStatus> getBlockStatus(BlockId blockId, boolean askSlaves) {
        BlockManagerMessages.GetBlockStatus msg = new BlockManagerMessages.GetBlockStatus(blockId, askSlaves);
        Map response = (Map)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Map.class));
        Tuple2 tuple2 = response.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Iterable blockManagerIds = (scala.collection.immutable.Iterable)tuple2._1();
        scala.collection.immutable.Iterable futures = (scala.collection.immutable.Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)blockManagerIds, (Object)futures);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Iterable blockManagerIds2 = (scala.collection.immutable.Iterable)tuple23._1();
        scala.collection.immutable.Iterable futures2 = (scala.collection.immutable.Iterable)tuple23._2();
        ExecutionContextExecutor sameThread = ThreadUtils$.MODULE$.sameThread();
        CanBuildFrom cbf = (CanBuildFrom)Predef$.MODULE$.implicitly((Object)scala.collection.Iterable$.MODULE$.canBuildFrom());
        Iterable blockStatus = (Iterable)this.timeout().awaitResult(Future$.MODULE$.sequence((TraversableOnce)futures2, cbf, (ExecutionContext)ThreadUtils$.MODULE$.sameThread()));
        if (blockStatus == null) {
            throw new SparkException(new StringBuilder(50).append("BlockManager returned null for BlockStatus query: ").append(blockId).toString());
        }
        return ((TraversableOnce)((TraversableLike)blockManagerIds2.zip((GenIterable)blockStatus, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
            Option status = (Option)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(status.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)blockManagerId, s)));
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public boolean getBlockStatus$default$2() {
        return true;
    }

    public Seq<BlockId> getMatchingBlockIds(Function1<BlockId, Object> filter, boolean askSlaves) {
        BlockManagerMessages.GetMatchingBlockIds msg = new BlockManagerMessages.GetMatchingBlockIds(filter, askSlaves);
        Future future = (Future)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Future.class));
        return (Seq)this.timeout().awaitResult(future);
    }

    public boolean hasCachedBlocks(String executorId) {
        return BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(new BlockManagerMessages.HasCachedBlocks(executorId), ClassTag$.MODULE$.Boolean()));
    }

    public void stop() {
        block0: {
            if (this.driverEndpoint() == null || !this.isDriver) break block0;
            this.tell(BlockManagerMessages$StopBlockManagerMaster$.MODULE$);
            this.driverEndpoint_$eq(null);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BlockManagerMaster stopped");
        }
    }

    private void tell(Object message) {
        if (!BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(message, ClassTag$.MODULE$.Boolean()))) {
            throw new SparkException("BlockManagerMasterEndpoint returned false, expected true.");
        }
    }

    public BlockManagerMaster(RpcEndpointRef driverEndpoint, SparkConf conf, boolean isDriver) {
        this.driverEndpoint = driverEndpoint;
        this.isDriver = isDriver;
        Logging.$init$(this);
        this.timeout = RpcUtils$.MODULE$.askRpcTimeout(conf);
    }
}

