/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.BadParameterException;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.status.api.v1.TaskSorting;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005]e!B\u0001\u0003\u0001\tq!AD*uC\u001e,7OU3t_V\u00148-\u001a\u0006\u0003\u0007\u0011\t!A^\u0019\u000b\u0005\u00151\u0011aA1qS*\u0011q\u0001C\u0001\u0007gR\fG/^:\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c2\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0005\u0006\u001cX-\u00119q%\u0016\u001cx.\u001e:dK\")!\u0004\u0001C\u00019\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001e!\t1\u0002\u0001C\u0003 \u0001\u0011\u0005\u0001%A\u0005ti\u0006<W\rT5tiR\u0011\u0011\u0005\r\t\u0004E)jcBA\u0012)\u001d\t!s%D\u0001&\u0015\t13$\u0001\u0004=e>|GOP\u0005\u0002%%\u0011\u0011&E\u0001\ba\u0006\u001c7.Y4f\u0013\tYCFA\u0002TKFT!!K\t\u0011\u0005Yq\u0013BA\u0018\u0003\u0005%\u0019F/Y4f\t\u0006$\u0018\rC\u00032=\u0001\u0007!'\u0001\u0005ti\u0006$Xo]3t!\r\u0019\u0004HO\u0007\u0002i)\u0011QGN\u0001\u0005kRLGNC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$\u0001\u0002'jgR\u0004\"AF\u001e\n\u0005q\u0012!aC*uC\u001e,7\u000b^1ukNDC\u0001\r I\u0013B\u0011qHR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0003eNT!a\u0011#\u0002\u0005]\u001c(\"A#\u0002\u000b)\fg/\u0019=\n\u0005\u001d\u0003%AC)vKJL\b+\u0019:b[\u0006)a/\u00197vK\u0006\nq\u0001\u000b\u0002\u001f\u0017B\u0011q\bT\u0005\u0003\u001b\u0002\u00131aR#U\u0011\u0015y\u0005\u0001\"\u0001Q\u0003%\u0019H/Y4f\t\u0006$\u0018\rF\u0002\"#nCQA\u0015(A\u0002M\u000bqa\u001d;bO\u0016LE\r\u0005\u0002\u0011)&\u0011Q+\u0005\u0002\u0004\u0013:$\b\u0006B)X\u0011j\u0003\"a\u0010-\n\u0005e\u0003%!\u0003)bi\"\u0004\u0016M]1nC\u0005\u0011\u0006\"\u0002/O\u0001\u0004i\u0016a\u00023fi\u0006LGn\u001d\t\u0003!yK!aX\t\u0003\u000f\t{w\u000e\\3b]\"\"1,\u0019%e!\ty$-\u0003\u0002d\u0001\naA)\u001a4bk2$h+\u00197vK\u0006\nQ-\u0001\u0003ueV,\u0007\u0006B.?\u0011\u001e\f\u0013\u0001\u0018\u0015\u0005\u001d&DE\u000e\u0005\u0002@U&\u00111\u000e\u0011\u0002\u0005!\u0006$\b.I\u0001n\u00039Y8\u000f^1hK&#'\b\t/eWuD#AT&\t\u000bA\u0004A\u0011A9\u0002\u001d=tW-\u0011;uK6\u0004H\u000fR1uCR!QF\u001d;y\u0011\u0015\u0011v\u000e1\u0001TQ\u0011\u0011x\u000b\u0013.\t\u000bU|\u0007\u0019A*\u0002\u001dM$\u0018mZ3BiR,W\u000e\u001d;JI\"\"Ao\u0016%xC\u0005)\b\"\u0002/p\u0001\u0004i\u0006\u0006\u0002=b\u0011\u0012DC\u0001\u001f IO\"\"q.\u001b%}C\u0005i\u0018\u0001J>ti\u0006<W-\u00133;Aq#7&`\u0018|gR\fw-Z!ui\u0016l\u0007\u000f^%eu\u0001bFmK?)\u0005=\\\u0005bBA\u0001\u0001\u0011\u0005\u00111A\u0001\fi\u0006\u001c8nU;n[\u0006\u0014\u0018\u0010\u0006\u0005\u0002\u0006\u0005-\u0011qBA\n!\r1\u0012qA\u0005\u0004\u0003\u0013\u0011!a\u0006+bg.lU\r\u001e:jG\u0012K7\u000f\u001e:jEV$\u0018n\u001c8t\u0011\u0015\u0011v\u00101\u0001TQ\u0015\tYa\u0016%[\u0011\u0015)x\u00101\u0001TQ\u0015\tya\u0016%x\u0011\u001d\t)b a\u0001\u0003/\ta\"];b]RLG.Z*ue&tw\r\u0005\u0003\u0002\u001a\u0005\u0005b\u0002BA\u000e\u0003;\u0001\"\u0001J\t\n\u0007\u0005}\u0011#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\t)C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?\t\u0002FBA\n}!\u000bI#\t\u0002\u0002,\u0005I\u0011/^1oi&dWm\u001d\u0015\u0007\u0003'\t\u0007*a\f\"\u0005\u0005E\u0012a\u0006\u0019/aUb\u0003G\f\u001a6YArS\u0007\f\u0019/oUb\u0003GL\u001d6Q\u0015y\u0018\u000eSA\u001bC\t\t9$\u0001\u0019|gR\fw-Z%eu\u0001bFmK?0wN$\u0018mZ3BiR,W\u000e\u001d;JIj\u0002C\fZ\u0016~_Q\f7o[*v[6\f'/\u001f\u0015\u0003\u007f.Cq!!\u0010\u0001\t\u0003\ty$\u0001\u0005uCN\\G*[:u)1\t\t%!\u0013\u0002N\u0005E\u0013qLA7!\u0011\u0011#&a\u0011\u0011\u0007Y\t)%C\u0002\u0002H\t\u0011\u0001\u0002V1tW\u0012\u000bG/\u0019\u0005\u0007%\u0006m\u0002\u0019A*)\u000b\u0005%s\u000b\u0013.\t\rU\fY\u00041\u0001TQ\u0015\tie\u0016%x\u0011\u001d\t\u0019&a\u000fA\u0002M\u000baa\u001c4gg\u0016$\bFBA)}!\u000b9&\t\u0002\u0002T!2\u0011\u0011K1I\u00037\n#!!\u0018\u0002\u0003ABq!!\u0019\u0002<\u0001\u00071+\u0001\u0004mK:<G\u000f\u001b\u0015\u0007\u0003?r\u0004*!\u001a\"\u0005\u0005\u0005\u0004FBA0C\"\u000bI'\t\u0002\u0002l\u0005\u0011!\u0007\r\u0005\t\u0003_\nY\u00041\u0001\u0002r\u000511o\u001c:u\u0005f\u00042AFA:\u0013\r\t)H\u0001\u0002\f)\u0006\u001c8nU8si&tw\r\u000b\u0004\u0002nyB\u0015\u0011P\u0011\u0003\u0003_Bc!!\u001cb\u0011\u0006u\u0014EAA@\u0003\tIE\t\u000b\u0004\u0002<%D\u00151Q\u0011\u0003\u0003\u000b\u000bQf_:uC\u001e,\u0017\n\u001a\u001e!9\u0012\\SpL>ti\u0006<W-\u0011;uK6\u0004H/\u00133;Aq#7&`\u0018uCN\\G*[:uQ\r\tYd\u0013\u0015\u0007\u0001\u0005-\u0005*!%\u0011\u0007}\ni)C\u0002\u0002\u0010\u0002\u0013\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u0003'\u000b#!!&\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007")
public class StagesResource
implements BaseAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$(this, fn);
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public String appId() {
        return this.appId;
    }

    @Override
    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    @Override
    public String attemptId() {
        return this.attemptId;
    }

    @Override
    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    public Seq<StageData> stageList(@QueryParam(value="status") List<StageStatus> statuses) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$1 -> x$1.store().stageList(statuses));
    }

    @GET
    @Path(value="{stageId: \\d+}")
    public Seq<StageData> stageData(@PathParam(value="stageId") int stageId, @DefaultValue(value="true") @QueryParam(value="details") boolean details) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            Seq<StageData> ret = ui.store().stageData(stageId, details);
            if (!ret.nonEmpty()) {
                throw new NotFoundException(new StringBuilder(15).append("unknown stage: ").append(stageId).toString());
            }
            return ret;
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}")
    public StageData oneAttemptData(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="true") @QueryParam(value="details") boolean details) {
        return (StageData)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            StageData stageData;
            try {
                stageData = ui.store().stageAttempt(stageId, stageAttemptId, details);
            }
            catch (NoSuchElementException noSuchElementException) {
                String string;
                Seq<StageData> all = ui.store().stageData(stageId, ui.store().stageData$default$2());
                if (all.nonEmpty()) {
                    Seq ids = (Seq)all.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.attemptId()), Seq$.MODULE$.canBuildFrom());
                    string = new StringBuilder(47).append("unknown attempt for stage ").append(stageId).append(".  Found attempts: [").append(ids.mkString(",")).append("]").toString();
                } else {
                    string = new StringBuilder(15).append("unknown stage: ").append(stageId).toString();
                }
                String msg = string;
                throw new NotFoundException(msg);
            }
            return stageData;
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskSummary")
    public TaskMetricDistributions taskSummary(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0.05,0.25,0.5,0.75,0.95") @QueryParam(value="quantiles") String quantileString) {
        return (TaskMetricDistributions)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            double[] quantiles = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])quantileString.split(","))).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToDouble((double)StagesResource.$anonfun$taskSummary$2(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            return (TaskMetricDistributions)ui.store().taskSummary(stageId, stageAttemptId, quantiles).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException(new StringBuilder(38).append("No tasks reported metrics for ").append(stageId).append(" / ").append(stageAttemptId).append(" yet.").toString());
            });
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskList")
    public Seq<TaskData> taskList(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="length") int length, @DefaultValue(value="ID") @QueryParam(value="sortBy") TaskSorting sortBy) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$3 -> x$3.store().taskList(stageId, stageAttemptId, offset, length, sortBy));
    }

    public static final /* synthetic */ double $anonfun$taskSummary$2(String s) {
        double d;
        try {
            d = new StringOps(Predef$.MODULE$.augmentString(s)).toDouble();
        }
        catch (NumberFormatException nfe) {
            throw new BadParameterException("quantiles", "double", s);
        }
        return d;
    }

    public StagesResource() {
        ApiRequestContext.$init$(this);
        BaseAppResource.$init$(this);
    }
}

