/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.DriverDescription;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.master.DriverState$;
import org.apache.spark.deploy.worker.CommandUtils$;
import org.apache.spark.deploy.worker.ProcessBuilderLike;
import org.apache.spark.deploy.worker.ProcessBuilderLike$;
import org.apache.spark.deploy.worker.Sleeper;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.io.Files;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc!B\u0001\u0003\u0001\u0011a!\u0001\u0004#sSZ,'OU;o]\u0016\u0014(BA\u0002\u0005\u0003\u00199xN]6fe*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011AcF\u0007\u0002+)\u0011aCB\u0001\tS:$XM\u001d8bY&\u0011\u0001$\u0006\u0002\b\u0019><w-\u001b8h\u0011!Q\u0002A!A!\u0002\u0013a\u0012\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002\u001e=5\ta!\u0003\u0002 \r\tI1\u000b]1sW\u000e{gN\u001a\u0005\tC\u0001\u0011)\u0019!C\u0001E\u0005AAM]5wKJLE-F\u0001$!\t!3F\u0004\u0002&SA\u0011aeD\u0007\u0002O)\u0011\u0001fG\u0001\u0007yI|w\u000e\u001e \n\u0005)z\u0011A\u0002)sK\u0012,g-\u0003\u0002-[\t11\u000b\u001e:j]\u001eT!AK\b\t\u0011=\u0002!\u0011!Q\u0001\n\r\n\u0011\u0002\u001a:jm\u0016\u0014\u0018\n\u001a\u0011\t\u0011E\u0002!Q1A\u0005\u0002I\nqa^8sW\u0012K'/F\u00014!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0002j_*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005\u00111\u0015\u000e\\3\t\u0011q\u0002!\u0011!Q\u0001\nM\n\u0001b^8sW\u0012K'\u000f\t\u0005\t}\u0001\u0011)\u0019!C\u0001e\u0005I1\u000f]1sW\"{W.\u001a\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005g\u0005Q1\u000f]1sW\"{W.\u001a\u0011\t\u0011\t\u0003!Q1A\u0005\u0002\r\u000b!\u0002\u001a:jm\u0016\u0014H)Z:d+\u0005!\u0005CA#G\u001b\u0005!\u0011BA$\u0005\u0005E!%/\u001b<fe\u0012+7o\u0019:jaRLwN\u001c\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\t\u0006YAM]5wKJ$Um]2!\u0011!\u0019\u0001A!b\u0001\n\u0003YU#\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0005=3\u0011a\u0001:qG&\u0011\u0011K\u0014\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011!\u0019\u0006A!A!\u0002\u0013a\u0015aB<pe.,'\u000f\t\u0005\t+\u0002\u0011)\u0019!C\u0001E\u0005Iqo\u001c:lKJ,&\u000f\u001c\u0005\t/\u0002\u0011\t\u0011)A\u0005G\u0005Qqo\u001c:lKJ,&\u000f\u001c\u0011\t\u0011e\u0003!Q1A\u0005\u0002i\u000bqb]3dkJLG/_'b]\u0006<WM]\u000b\u00027B\u0011Q\u0004X\u0005\u0003;\u001a\u0011qbU3dkJLG/_'b]\u0006<WM\u001d\u0005\t?\u0002\u0011\t\u0011)A\u00057\u0006\u00012/Z2ve&$\u00180T1oC\u001e,'\u000f\t\u0005\u0006C\u0002!\tAY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013\r,gm\u001a5jU.d\u0007C\u00013\u0001\u001b\u0005\u0011\u0001\"\u0002\u000ea\u0001\u0004a\u0002\"B\u0011a\u0001\u0004\u0019\u0003\"B\u0019a\u0001\u0004\u0019\u0004\"\u0002 a\u0001\u0004\u0019\u0004\"\u0002\"a\u0001\u0004!\u0005\"B\u0002a\u0001\u0004a\u0005\"B+a\u0001\u0004\u0019\u0003\"B-a\u0001\u0004Y\u0006b\u00028\u0001\u0001\u0004%Ia\\\u0001\baJ|7-Z:t+\u0005\u0001\bc\u0001\brg&\u0011!o\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Q<X\"A;\u000b\u0005Y<\u0014\u0001\u00027b]\u001eL!\u0001_;\u0003\u000fA\u0013xnY3tg\"9!\u0010\u0001a\u0001\n\u0013Y\u0018a\u00039s_\u000e,7o]0%KF$\"\u0001`@\u0011\u00059i\u0018B\u0001@\u0010\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005\u00110!AA\u0002A\f1\u0001\u001f\u00132\u0011\u001d\t)\u0001\u0001Q!\nA\f\u0001\u0002\u001d:pG\u0016\u001c8\u000f\t\u0015\u0005\u0003\u0007\tI\u0001E\u0002\u000f\u0003\u0017I1!!\u0004\u0010\u0005!1x\u000e\\1uS2,\u0007\"CA\t\u0001\u0001\u0007I\u0011BA\n\u0003\u0019Y\u0017\u000e\u001c7fIV\u0011\u0011Q\u0003\t\u0004\u001d\u0005]\u0011bAA\r\u001f\t9!i\\8mK\u0006t\u0007\"CA\u000f\u0001\u0001\u0007I\u0011BA\u0010\u0003)Y\u0017\u000e\u001c7fI~#S-\u001d\u000b\u0004y\u0006\u0005\u0002BCA\u0001\u00037\t\t\u00111\u0001\u0002\u0016!A\u0011Q\u0005\u0001!B\u0013\t)\"A\u0004lS2dW\r\u001a\u0011)\t\u0005\r\u0012\u0011\u0002\u0005\u000b\u0003W\u0001\u0001\u0019!C\u0001\u0005\u00055\u0012A\u00034j]\u0006d7\u000b^1uKV\u0011\u0011q\u0006\t\u0005\u001dE\f\t\u0004\u0005\u0003\u00024\u0005Ec\u0002BA\u001b\u0003\u0017rA!a\u000e\u0002H9!\u0011\u0011HA#\u001d\u0011\tY$a\u0011\u000f\t\u0005u\u0012\u0011\t\b\u0004M\u0005}\u0012\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!C\u0002\u0002J\u0011\ta!\\1ti\u0016\u0014\u0018\u0002BA'\u0003\u001f\n1\u0002\u0012:jm\u0016\u00148\u000b^1uK*\u0019\u0011\u0011\n\u0003\n\t\u0005M\u0013Q\u000b\u0002\f\tJLg/\u001a:Ti\u0006$XM\u0003\u0003\u0002N\u0005=\u0003BCA-\u0001\u0001\u0007I\u0011\u0001\u0002\u0002\\\u0005qa-\u001b8bYN#\u0018\r^3`I\u0015\fHc\u0001?\u0002^!Q\u0011\u0011AA,\u0003\u0003\u0005\r!a\f\t\u0011\u0005\u0005\u0004\u0001)Q\u0005\u0003_\t1BZ5oC2\u001cF/\u0019;fA!\"\u0011qLA\u0005\u0011)\t9\u0007\u0001a\u0001\n\u0003\u0011\u0011\u0011N\u0001\u000fM&t\u0017\r\\#yG\u0016\u0004H/[8o+\t\tY\u0007\u0005\u0003\u000fc\u00065\u0004\u0003BA8\u0003srA!!\u001d\u0002v9\u0019a%a\u001d\n\u0003AI1!a\u001e\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001f\u0002~\tIQ\t_2faRLwN\u001c\u0006\u0004\u0003oz\u0001BCAA\u0001\u0001\u0007I\u0011\u0001\u0002\u0002\u0004\u0006\u0011b-\u001b8bY\u0016C8-\u001a9uS>tw\fJ3r)\ra\u0018Q\u0011\u0005\u000b\u0003\u0003\ty(!AA\u0002\u0005-\u0004\u0002CAE\u0001\u0001\u0006K!a\u001b\u0002\u001f\u0019Lg.\u00197Fq\u000e,\u0007\u000f^5p]\u0002BC!a\"\u0002\n!I\u0011q\u0012\u0001C\u0002\u0013%\u0011\u0011S\u0001\u001c\tJKe+\u0012*`)\u0016\u0013V*\u0013(B)\u0016{F+S'F\u001fV#v,T*\u0016\u0005\u0005M\u0005c\u0001\b\u0002\u0016&\u0019\u0011qS\b\u0003\t1{gn\u001a\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002\u0014\u0006aBIU%W\u000bJ{F+\u0012*N\u0013:\u000bE+R0U\u00136+u*\u0016+`\u001bN\u0003\u0003bBAP\u0001\u0011\u0005\u0011\u0011U\u0001\tg\u0016$8\t\\8dWR\u0019A0a)\t\u0011\u0005\u0015\u0016Q\u0014a\u0001\u0003O\u000baaX2m_\u000e\\\u0007\u0003BAU\u0003_k!!a+\u000b\u0007\u00055f!\u0001\u0003vi&d\u0017\u0002BAY\u0003W\u0013Qa\u00117pG.Dq!!.\u0001\t\u0003\t9,\u0001\u0006tKR\u001cF.Z3qKJ$2\u0001`A]\u0011!\tY,a-A\u0002\u0005u\u0016\u0001C0tY\u0016,\u0007/\u001a:\u0011\u0007\u0011\fy,C\u0002\u0002B\n\u0011qa\u00157fKB,'\u000fC\u0005\u0002F\u0002\u0001\r\u0011\"\u0003\u0002H\u0006)1\r\\8dWV\u0011\u0011q\u0015\u0005\n\u0003\u0017\u0004\u0001\u0019!C\u0005\u0003\u001b\f\u0011b\u00197pG.|F%Z9\u0015\u0007q\fy\r\u0003\u0006\u0002\u0002\u0005%\u0017\u0011!a\u0001\u0003OC\u0001\"a5\u0001A\u0003&\u0011qU\u0001\u0007G2|7m\u001b\u0011\t\u0013\u0005]\u0007\u00011A\u0005\n\u0005e\u0017aB:mK\u0016\u0004XM]\u000b\u0003\u00037\u0014R!!8\u000e\u0003{3q!a8\u0002b\u0002\tYN\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0003\u0005\u0002d\u0002\u0001\u000b\u0015BAn\u0003!\u0019H.Z3qKJ\u0004\u0003\"CAt\u0001\u0001\u0007I\u0011BAu\u0003-\u0019H.Z3qKJ|F%Z9\u0015\u0007q\fY\u000f\u0003\u0006\u0002\u0002\u0005\u0015\u0018\u0011!a\u0001\u00037D\u0001\"a<\u0001\t\u0003\u0011\u0011\u0011_\u0001\u0006gR\f'\u000f\u001e\u000b\u0002y\"A\u0011Q\u001f\u0001\u0005\u0002\t\t\t0\u0001\u0003lS2d\u0007bBA}\u0001\u0011%\u00111`\u0001\u0017GJ,\u0017\r^3X_J\\\u0017N\\4ESJ,7\r^8ssR\t1\u0007C\u0004\u0002\u0000\u0002!IA!\u0001\u0002\u001f\u0011|wO\u001c7pC\u0012,6/\u001a:KCJ$2a\tB\u0002\u0011\u001d\u0011)!!@A\u0002M\n\u0011\u0002\u001a:jm\u0016\u0014H)\u001b:\t\u0011\t%\u0001\u0001\"\u0001\u0003\u0005\u0017\t1\u0003\u001d:fa\u0006\u0014X-\u00118e%VtGI]5wKJ$\"A!\u0004\u0011\u00079\u0011y!C\u0002\u0003\u0012=\u00111!\u00138u\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/\t\u0011B];o\tJLg/\u001a:\u0015\u0011\t5!\u0011\u0004B\u0012\u0005OA\u0001Ba\u0007\u0003\u0014\u0001\u0007!QD\u0001\bEVLG\u000eZ3s!\r!(qD\u0005\u0004\u0005C)(A\u0004)s_\u000e,7o\u001d\"vS2$WM\u001d\u0005\b\u0005K\u0011\u0019\u00021\u00014\u0003\u001d\u0011\u0017m]3ESJD\u0001B!\u000b\u0003\u0014\u0001\u0007\u0011QC\u0001\ngV\u0004XM\u001d<jg\u0016D\u0001B!\f\u0001\t\u0003\u0011!qF\u0001\u0014eVt7i\\7nC:$w+\u001b;i%\u0016$(/\u001f\u000b\t\u0005\u001b\u0011\tDa\u000f\u0003F!A!1\u0007B\u0016\u0001\u0004\u0011)$A\u0004d_6l\u0017M\u001c3\u0011\u0007\u0011\u00149$C\u0002\u0003:\t\u0011!\u0003\u0015:pG\u0016\u001c8OQ;jY\u0012,'\u000fT5lK\"A!Q\bB\u0016\u0001\u0004\u0011y$\u0001\u0006j]&$\u0018.\u00197ju\u0016\u0004RA\u0004B!grL1Aa\u0011\u0010\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0005\u0003*\t-\u0002\u0019AA\u000b\u0001")
public class DriverRunner
implements Logging {
    private final SparkConf conf;
    private final String driverId;
    private final File workDir;
    private final File sparkHome;
    private final DriverDescription driverDesc;
    private final RpcEndpointRef worker;
    private final String workerUrl;
    private final SecurityManager securityManager;
    private volatile Option<Process> process;
    private volatile boolean org$apache$spark$deploy$worker$DriverRunner$$killed;
    private volatile Option<Enumeration.Value> finalState;
    private volatile Option<Exception> finalException;
    private final long DRIVER_TERMINATE_TIMEOUT_MS;
    private Clock clock;
    private Sleeper sleeper;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String driverId() {
        return this.driverId;
    }

    public File workDir() {
        return this.workDir;
    }

    public File sparkHome() {
        return this.sparkHome;
    }

    public DriverDescription driverDesc() {
        return this.driverDesc;
    }

    public RpcEndpointRef worker() {
        return this.worker;
    }

    public String workerUrl() {
        return this.workerUrl;
    }

    public SecurityManager securityManager() {
        return this.securityManager;
    }

    private Option<Process> process() {
        return this.process;
    }

    private void process_$eq(Option<Process> x$1) {
        this.process = x$1;
    }

    public boolean org$apache$spark$deploy$worker$DriverRunner$$killed() {
        return this.org$apache$spark$deploy$worker$DriverRunner$$killed;
    }

    private void org$apache$spark$deploy$worker$DriverRunner$$killed_$eq(boolean x$1) {
        this.org$apache$spark$deploy$worker$DriverRunner$$killed = x$1;
    }

    public Option<Enumeration.Value> finalState() {
        return this.finalState;
    }

    public void finalState_$eq(Option<Enumeration.Value> x$1) {
        this.finalState = x$1;
    }

    public Option<Exception> finalException() {
        return this.finalException;
    }

    public void finalException_$eq(Option<Exception> x$1) {
        this.finalException = x$1;
    }

    private long DRIVER_TERMINATE_TIMEOUT_MS() {
        return this.DRIVER_TERMINATE_TIMEOUT_MS;
    }

    public void setClock(Clock _clock) {
        this.clock_$eq(_clock);
    }

    public void setSleeper(Sleeper _sleeper) {
        this.sleeper_$eq(_sleeper);
    }

    private Clock clock() {
        return this.clock;
    }

    private void clock_$eq(Clock x$1) {
        this.clock = x$1;
    }

    private Sleeper sleeper() {
        return this.sleeper;
    }

    private void sleeper_$eq(Sleeper x$1) {
        this.sleeper = x$1;
    }

    public void start() {
        new Thread(this){
            private final /* synthetic */ DriverRunner $outer;

            public void run() {
                Object shutdownHook = null;
                try {
                    try {
                        shutdownHook = ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Worker shutting down, killing driver ").append($this.$outer.driverId()).toString());
                            $this.$outer.kill();
                        });
                        int exitCode = this.$outer.prepareAndRunDriver();
                        this.$outer.finalState_$eq((Option<Enumeration.Value>)(exitCode == 0 ? new Some((Object)DriverState$.MODULE$.FINISHED()) : (this.$outer.org$apache$spark$deploy$worker$DriverRunner$$killed() ? new Some((Object)DriverState$.MODULE$.KILLED()) : new Some((Object)DriverState$.MODULE$.FAILED()))));
                    }
                    catch (Exception e) {
                        this.$outer.kill();
                        this.$outer.finalState_$eq((Option<Enumeration.Value>)new Some((Object)DriverState$.MODULE$.ERROR()));
                        this.$outer.finalException_$eq((Option<Exception>)new Some((Object)e));
                    }
                }
                finally {
                    if (shutdownHook != null) {
                        ShutdownHookManager$.MODULE$.removeShutdownHook(shutdownHook);
                    }
                }
                this.$outer.worker().send(new DeployMessages.DriverStateChanged(this.$outer.driverId(), (Enumeration.Value)this.$outer.finalState().get(), this.$outer.finalException()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(17).append("DriverRunner for ").append($outer.driverId()).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.deploy.worker.DriverRunner$$anon$1 ), $anonfun$run$2(org.apache.spark.deploy.worker.DriverRunner$$anon$1 )}, serializedLambda);
            }
        }.start();
    }

    public void kill() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Killing driver process!");
        this.org$apache$spark$deploy$worker$DriverRunner$$killed_$eq(true);
        DriverRunner driverRunner = this;
        synchronized (driverRunner) {
            this.process().foreach((Function1 & Serializable & scala.Serializable)p -> {
                DriverRunner.$anonfun$kill$2(this, p);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private File createWorkingDirectory() {
        void var1_1;
        File driverDir = new File(this.workDir(), this.driverId());
        if (!driverDir.exists() && !driverDir.mkdirs()) {
            throw new IOException(new StringBuilder(27).append("Failed to create directory ").append(driverDir).toString());
        }
        return var1_1;
    }

    private String downloadUserJar(File driverDir) {
        String jarFileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new URI(this.driverDesc().jarUrl()).getPath().split("/"))).last();
        File localJarFile = new File(driverDir, jarFileName);
        if (!localJarFile.exists()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Copying user jar ").append(this.driverDesc().jarUrl()).append(" to ").append(localJarFile).toString());
            Utils$.MODULE$.fetchFile(this.driverDesc().jarUrl(), driverDir, this.conf, this.securityManager(), SparkHadoopUtil$.MODULE$.get().newConfiguration(this.conf), System.currentTimeMillis(), false);
            if (!localJarFile.exists()) {
                throw new IOException(new StringBuilder(60).append("Can not find expected jar ").append(jarFileName).append(" which should have been loaded in ").append(driverDir).toString());
            }
        }
        return localJarFile.getAbsolutePath();
    }

    public int prepareAndRunDriver() {
        File driverDir = this.createWorkingDirectory();
        String localJarFilename = this.downloadUserJar(driverDir);
        ProcessBuilder builder = CommandUtils$.MODULE$.buildProcessBuilder(this.driverDesc().command(), this.securityManager(), this.driverDesc().mem(), this.sparkHome().getAbsolutePath(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)argument -> this.substituteVariables$1((String)argument, localJarFilename), CommandUtils$.MODULE$.buildProcessBuilder$default$6(), CommandUtils$.MODULE$.buildProcessBuilder$default$7());
        return this.runDriver(builder, driverDir, this.driverDesc().supervise());
    }

    private int runDriver(ProcessBuilder builder, File baseDir, boolean supervise) {
        builder.directory(baseDir);
        return this.runCommandWithRetry(ProcessBuilderLike$.MODULE$.apply(builder), (Function1<Process, BoxedUnit>)(Function1 & Serializable & scala.Serializable)process -> {
            DriverRunner.initialize$1(process, builder, baseDir);
            return BoxedUnit.UNIT;
        }, supervise);
    }

    public int runCommandWithRetry(ProcessBuilderLike command, Function1<Process, BoxedUnit> initialize, boolean supervise) {
        boolean keepTrying;
        IntRef exitCode = IntRef.create((int)-1);
        IntRef waitSeconds = IntRef.create((int)1);
        int successfulRunDuration = 5;
        boolean bl = keepTrying = !this.org$apache$spark$deploy$worker$DriverRunner$$killed();
        while (keepTrying) {
            block7: {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Launch Command: ").append(command.command().mkString("\"", "\" \"", "\"")).toString());
                DriverRunner driverRunner = this;
                synchronized (driverRunner) {
                    int n;
                    block6: {
                        if (this.org$apache$spark$deploy$worker$DriverRunner$$killed()) {
                            n = exitCode.elem;
                            break block6;
                        }
                        this.process_$eq((Option<Process>)new Some((Object)command.start()));
                        initialize.apply(this.process().get());
                        break block7;
                    }
                    return n;
                }
            }
            long processStart = this.clock().getTimeMillis();
            exitCode.elem = ((Process)this.process().get()).waitFor();
            keepTrying = supervise && exitCode.elem != 0 && !this.org$apache$spark$deploy$worker$DriverRunner$$killed();
            if (!keepTrying) continue;
            if (this.clock().getTimeMillis() - processStart > (long)successfulRunDuration * 1000L) {
                waitSeconds.elem = 1;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Command exited with status ").append(exitCode$1.elem).append(", re-launching after ").append(waitSeconds$1.elem).append(" s.").toString());
            this.sleeper().sleep(waitSeconds.elem);
            waitSeconds.elem *= 2;
        }
        return exitCode.elem;
    }

    public static final /* synthetic */ void $anonfun$kill$2(DriverRunner $this, Process p) {
        block0: {
            Option<Object> exitCode = Utils$.MODULE$.terminateProcess(p, $this.DRIVER_TERMINATE_TIMEOUT_MS());
            if (!exitCode.isEmpty()) break block0;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to terminate driver process: ").append(p).append(". This process will likely be orphaned.").toString());
        }
    }

    private final String substituteVariables$1(String argument, String localJarFilename$1) {
        String string = argument;
        String string2 = "{{WORKER_URL}}".equals(string) ? this.workerUrl() : ("{{USER_JAR}}".equals(string) ? localJarFilename$1 : string);
        return string2;
    }

    private static final void initialize$1(Process process, ProcessBuilder builder$1, File baseDir$1) {
        File stdout = new File(baseDir$1, "stdout");
        CommandUtils$.MODULE$.redirectStream(process.getInputStream(), stdout);
        File stderr = new File(baseDir$1, "stderr");
        String formattedCommand = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(builder$1.command()).asScala()).mkString("\"", "\" \"", "\"");
        String header = new StringOps(Predef$.MODULE$.augmentString("Launch Command: %s\n%s\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedCommand, new StringOps(Predef$.MODULE$.augmentString("=")).$times(40)}));
        Files.append((CharSequence)header, (File)stderr, (Charset)StandardCharsets.UTF_8);
        CommandUtils$.MODULE$.redirectStream(process.getErrorStream(), stderr);
    }

    public DriverRunner(SparkConf conf, String driverId, File workDir, File sparkHome, DriverDescription driverDesc, RpcEndpointRef worker, String workerUrl, SecurityManager securityManager) {
        this.conf = conf;
        this.driverId = driverId;
        this.workDir = workDir;
        this.sparkHome = sparkHome;
        this.driverDesc = driverDesc;
        this.worker = worker;
        this.workerUrl = workerUrl;
        this.securityManager = securityManager;
        Logging.$init$(this);
        this.process = None$.MODULE$;
        this.org$apache$spark$deploy$worker$DriverRunner$$killed = false;
        this.finalState = None$.MODULE$;
        this.finalException = None$.MODULE$;
        this.DRIVER_TERMINATE_TIMEOUT_MS = conf.getTimeAsMs("spark.worker.driverTerminateTimeout", "10s");
        this.clock = new SystemClock();
        this.sleeper = new Sleeper(this){
            private final /* synthetic */ DriverRunner $outer;

            public void sleep(int seconds) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), seconds).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> {
                    Thread.sleep(1000L);
                    return !$this.$outer.org$apache$spark$deploy$worker$DriverRunner$$killed();
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$sleep$1(org.apache.spark.deploy.worker.DriverRunner$$anon$2 int )}, serializedLambda);
            }
        };
    }
}

