/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.master.Master$;
import org.apache.spark.deploy.worker.Worker$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000154Q!\u0001\u0002\u0001\t)\u0011\u0011\u0003T8dC2\u001c\u0006/\u0019:l\u00072,8\u000f^3s\u0015\t\u0019A!\u0001\u0004eKBdw.\u001f\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sON\u0019\u0001aC\t\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\t\u0011R#D\u0001\u0014\u0015\t!B!\u0001\u0005j]R,'O\\1m\u0013\t12CA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!\u0011!Q\u0001\ni\t!B\\;n/>\u00148.\u001a:t\u0007\u0001\u0001\"\u0001D\u000e\n\u0005qi!aA%oi\"Aa\u0004\u0001B\u0001B\u0003%!$\u0001\bd_J,7\u000fU3s/>\u00148.\u001a:\t\u0011\u0001\u0002!\u0011!Q\u0001\ni\tq\"\\3n_JL\b+\u001a:X_J\\WM\u001d\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005!1m\u001c8g!\t!S%D\u0001\u0005\u0013\t1CAA\u0005Ta\u0006\u00148nQ8oM\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"RA\u000b\u0017.]=\u0002\"a\u000b\u0001\u000e\u0003\tAQ\u0001G\u0014A\u0002iAQAH\u0014A\u0002iAQ\u0001I\u0014A\u0002iAQAI\u0014A\u0002\rBq!\r\u0001C\u0002\u0013%!'A\u0007m_\u000e\fG\u000eS8ti:\fW.Z\u000b\u0002gA\u0011Ag\u000f\b\u0003ke\u0002\"AN\u0007\u000e\u0003]R!\u0001O\r\u0002\rq\u0012xn\u001c;?\u0013\tQT\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e\u000e\u0011\u0019y\u0004\u0001)A\u0005g\u0005qAn\\2bY\"{7\u000f\u001e8b[\u0016\u0004\u0003bB!\u0001\u0005\u0004%IAQ\u0001\u000e[\u0006\u001cH/\u001a:Sa\u000e,eN^:\u0016\u0003\r\u00032\u0001R%L\u001b\u0005)%B\u0001$H\u0003\u001diW\u000f^1cY\u0016T!\u0001S\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002K\u000b\nY\u0011I\u001d:bs\n+hMZ3s!\tau*D\u0001N\u0015\tqE!A\u0002sa\u000eL!\u0001U'\u0003\rI\u00038-\u00128w\u0011\u0019\u0011\u0006\u0001)A\u0005\u0007\u0006qQ.Y:uKJ\u0014\u0006oY#omN\u0004\u0003b\u0002+\u0001\u0005\u0004%IAQ\u0001\u000eo>\u00148.\u001a:Sa\u000e,eN^:\t\rY\u0003\u0001\u0015!\u0003D\u000399xN]6feJ\u00038-\u00128wg\u0002Bq\u0001\u0017\u0001A\u0002\u0013\u0005\u0011,A\bnCN$XM],fEVK\u0005k\u001c:u+\u0005Q\u0002bB.\u0001\u0001\u0004%\t\u0001X\u0001\u0014[\u0006\u001cH/\u001a:XK\n,\u0016\nU8si~#S-\u001d\u000b\u0003;\u0002\u0004\"\u0001\u00040\n\u0005}k!\u0001B+oSRDq!\u0019.\u0002\u0002\u0003\u0007!$A\u0002yIEBaa\u0019\u0001!B\u0013Q\u0012\u0001E7bgR,'oV3c+&\u0003vN\u001d;!\u0011\u0015)\u0007\u0001\"\u0001g\u0003\u0015\u0019H/\u0019:u)\u00059\u0007c\u0001\u0007ig%\u0011\u0011.\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006W\u0002!\t\u0001\\\u0001\u0005gR|\u0007\u000fF\u0001^\u0001")
public class LocalSparkCluster
implements Logging {
    private final int numWorkers;
    private final int coresPerWorker;
    private final int memoryPerWorker;
    private final SparkConf conf;
    private final String localHostname;
    private final ArrayBuffer<RpcEnv> masterRpcEnvs;
    private final ArrayBuffer<RpcEnv> workerRpcEnvs;
    private int masterWebUIPort;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String localHostname() {
        return this.localHostname;
    }

    private ArrayBuffer<RpcEnv> masterRpcEnvs() {
        return this.masterRpcEnvs;
    }

    private ArrayBuffer<RpcEnv> workerRpcEnvs() {
        return this.workerRpcEnvs;
    }

    public int masterWebUIPort() {
        return this.masterWebUIPort;
    }

    public void masterWebUIPort_$eq(int x$1) {
        this.masterWebUIPort = x$1;
    }

    public String[] start() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Starting a local Spark cluster with ").append($this.numWorkers).append(" workers.").toString());
        SparkConf _conf = this.conf.clone().setIfMissing("spark.master.rest.enabled", "false").set(package$.MODULE$.SHUFFLE_SERVICE_ENABLED().key(), "false");
        Tuple3<RpcEnv, Object, Option<Object>> tuple3 = Master$.MODULE$.startRpcEnvAndEndpoint(this.localHostname(), 0, 0, _conf);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        RpcEnv rpcEnv = (RpcEnv)tuple3._1();
        int webUiPort = BoxesRunTime.unboxToInt((Object)tuple3._2());
        Tuple2 tuple2 = new Tuple2((Object)rpcEnv, (Object)BoxesRunTime.boxToInteger((int)webUiPort));
        Tuple2 tuple22 = tuple2;
        RpcEnv rpcEnv2 = (RpcEnv)tuple22._1();
        int webUiPort2 = tuple22._2$mcI$sp();
        this.masterWebUIPort_$eq(webUiPort2);
        this.masterRpcEnvs().$plus$eq((Object)rpcEnv2);
        String masterUrl = new StringBuilder(9).append("spark://").append(Utils$.MODULE$.localHostNameForURI()).append(":").append(rpcEnv2.address().port()).toString();
        String[] masters = (String[])((Object[])new String[]{masterUrl});
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numWorkers).foreach((Function1 & Serializable & scala.Serializable)workerNum -> LocalSparkCluster.$anonfun$start$2(this, _conf, masters, BoxesRunTime.unboxToInt((Object)workerNum)));
        return masters;
    }

    public void stop() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down local Spark cluster.");
        this.workerRpcEnvs().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.masterRpcEnvs().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.workerRpcEnvs().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.awaitTermination();
            return BoxedUnit.UNIT;
        });
        this.masterRpcEnvs().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.awaitTermination();
            return BoxedUnit.UNIT;
        });
        this.masterRpcEnvs().clear();
        this.workerRpcEnvs().clear();
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$start$2(LocalSparkCluster $this, SparkConf _conf$1, String[] masters$1, int workerNum) {
        RpcEnv workerEnv = Worker$.MODULE$.startRpcEnvAndEndpoint($this.localHostname(), 0, 0, $this.coresPerWorker, $this.memoryPerWorker, masters$1, null, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)workerNum)), _conf$1);
        return $this.workerRpcEnvs().$plus$eq((Object)workerEnv);
    }

    public LocalSparkCluster(int numWorkers, int coresPerWorker, int memoryPerWorker, SparkConf conf) {
        this.numWorkers = numWorkers;
        this.coresPerWorker = coresPerWorker;
        this.memoryPerWorker = memoryPerWorker;
        this.conf = conf;
        Logging.$init$(this);
        this.localHostname = Utils$.MODULE$.localHostName();
        this.masterRpcEnvs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.workerRpcEnvs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.masterWebUIPort = -1;
    }
}

