/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.r;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.api.r.JVMObjectId;
import org.apache.spark.api.r.RBackend;
import org.apache.spark.api.r.SerDe$;
import org.apache.spark.api.r.SparkRDefaults$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\u0005\rd!B\u0001\u0003\u0001\ta!a\u0004*CC\u000e\\WM\u001c3IC:$G.\u001a:\u000b\u0005\r!\u0011!\u0001:\u000b\u0005\u00151\u0011aA1qS*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001b\u0001\u00022AD\u000b\u0018\u001b\u0005y!B\u0001\t\u0012\u0003\u001d\u0019\u0007.\u00198oK2T!AE\n\u0002\u000b9,G\u000f^=\u000b\u0003Q\t!![8\n\u0005Yy!aG*j[BdWm\u00115b]:,G.\u00138c_VtG\rS1oI2,'\u000fE\u0002\u00197ui\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00031yI!aH\r\u0003\t\tKH/\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003G\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003K\t\u0012q\u0001T8hO&tw\r\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003*\u0003\u0019\u0019XM\u001d<fe\u000e\u0001\u0001C\u0001\u0016,\u001b\u0005\u0011\u0011B\u0001\u0017\u0003\u0005!\u0011&)Y2lK:$\u0007\"\u0002\u0018\u0001\t\u0003y\u0013A\u0002\u001fj]&$h\b\u0006\u00021cA\u0011!\u0006\u0001\u0005\u0006O5\u0002\r!\u000b\u0005\u0006g\u0001!\t\u0005N\u0001\rG\"\fgN\\3m%\u0016\fG\r\r\u000b\u0004kaj\u0004C\u0001\r7\u0013\t9\u0014D\u0001\u0003V]&$\b\"B\u001d3\u0001\u0004Q\u0014aA2uqB\u0011abO\u0005\u0003y=\u0011Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0003?e\u0001\u0007q#A\u0002ng\u001eDQ\u0001\u0011\u0001\u0005B\u0005\u000b1c\u00195b]:,GNU3bI\u000e{W\u000e\u001d7fi\u0016$\"!\u000e\"\t\u000bez\u0004\u0019\u0001\u001e\t\u000b\u0011\u0003A\u0011I#\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$2!\u000e$H\u0011\u0015I4\t1\u0001;\u0011\u0015A5\t1\u0001J\u0003\u0015\u0019\u0017-^:f!\tQ%K\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011a\nK\u0001\u0007yI|w\u000e\u001e \n\u0003iI!!U\r\u0002\u000fA\f7m[1hK&\u00111\u000b\u0016\u0002\n)\"\u0014xn^1cY\u0016T!!U\r\t\u000bY\u0003A\u0011A,\u0002!!\fg\u000e\u001a7f\u001b\u0016$\bn\u001c3DC2dGcB\u001bY;\u001eLgn\u001e\u0005\u00063V\u0003\rAW\u0001\tSN\u001cF/\u0019;jGB\u0011\u0001dW\u0005\u00039f\u0011qAQ8pY\u0016\fg\u000eC\u0003_+\u0002\u0007q,A\u0003pE*LE\r\u0005\u0002aI:\u0011\u0011M\u0019\t\u0003\u0019fI!aY\r\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GfAQ\u0001[+A\u0002}\u000b!\"\\3uQ>$g*Y7f\u0011\u0015QW\u000b1\u0001l\u0003\u001dqW/\\!sON\u0004\"\u0001\u00077\n\u00055L\"aA%oi\")q.\u0016a\u0001a\u0006\u0019A-[:\u0011\u0005E,X\"\u0001:\u000b\u0005Q\u0019(\"\u0001;\u0002\t)\fg/Y\u0005\u0003mJ\u0014q\u0002R1uC&s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006qV\u0003\r!_\u0001\u0004I>\u001c\bCA9{\u0013\tY(O\u0001\tECR\fw*\u001e;qkR\u001cFO]3b[\")Q\u0010\u0001C\u0001}\u0006A!/Z1e\u0003J<7\u000fF\u0003\u0000\u0003\u001b\ty\u0001\u0005\u0003\u00197\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d1/\u0001\u0003mC:<\u0017\u0002BA\u0006\u0003\u000b\u0011aa\u00142kK\u000e$\b\"\u00026}\u0001\u0004Y\u0007\"B8}\u0001\u0004\u0001\bbBA\n\u0001\u0011\u0005\u0011QC\u0001\u0015M&tG-T1uG\",GmU5h]\u0006$XO]3\u0015\r\u0005]\u0011QDA\"!\u0011A\u0012\u0011D6\n\u0007\u0005m\u0011D\u0001\u0004PaRLwN\u001c\u0005\t\u0003?\t\t\u00021\u0001\u0002\"\u00059\u0002/\u0019:b[\u0016$XM\u001d+za\u0016\u001cxJZ'fi\"|Gm\u001d\t\u00051m\t\u0019\u0003\u0005\u0003\u00197\u0005\u0015\u0002\u0007BA\u0014\u0003c\u0001R\u0001YA\u0015\u0003[I1!a\u000bg\u0005\u0015\u0019E.Y:t!\u0011\ty#!\r\r\u0001\u0011a\u00111GA\u000f\u0003\u0003\u0005\tQ!\u0001\u00026\t\u0019q\fJ\u0019\u0012\t\u0005]\u0012Q\b\t\u00041\u0005e\u0012bAA\u001e3\t9aj\u001c;iS:<\u0007c\u0001\r\u0002@%\u0019\u0011\u0011I\r\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002F\u0005E\u0001\u0019A@\u0002\t\u0005\u0014xm\u001d\u0015\u0004\u0001\u0005%\u0003\u0003BA&\u0003;rA!!\u0014\u0002Z9!\u0011qJA,\u001d\u0011\t\t&!\u0016\u000f\u00071\u000b\u0019&C\u0001\u0015\u0013\t\u00112#\u0003\u0002\u0011#%\u0019\u00111L\b\u0002\u001d\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe&!\u0011qLA1\u0005!\u0019\u0006.\u0019:bE2,'bAA.\u001f\u0001")
public class RBackendHandler
extends SimpleChannelInboundHandler<byte[]>
implements Logging {
    private final RBackend server;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void channelRead0(ChannelHandlerContext ctx, byte[] msg) {
        Object object;
        ByteArrayInputStream bis = new ByteArrayInputStream(msg);
        DataInputStream dis = new DataInputStream(bis);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        boolean isStatic = SerDe$.MODULE$.readBoolean(dis);
        String objId = SerDe$.MODULE$.readString(dis);
        String methodName = SerDe$.MODULE$.readString(dis);
        int numArgs = SerDe$.MODULE$.readInt(dis);
        String string = objId;
        String string2 = "SparkRHandler";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = methodName;
            if ("echo".equals(string3)) {
                Object[] args = this.readArgs(numArgs, dis);
                Predef$.MODULE$.assert(numArgs == 1);
                SerDe$.MODULE$.writeInt(dos, 0);
                SerDe$.MODULE$.writeObject(dos, args[0], this.server.jvmObjectTracker());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("stopBackend".equals(string3)) {
                SerDe$.MODULE$.writeInt(dos, 0);
                SerDe$.MODULE$.writeType(dos, "void");
                this.server.close();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("rm".equals(string3)) {
                BoxedUnit boxedUnit;
                try {
                    char t = SerDe$.MODULE$.readObjectType(dis);
                    Predef$.MODULE$.assert(t == 'c');
                    String objToRemove = SerDe$.MODULE$.readString(dis);
                    this.server.jvmObjectTracker().remove(new JVMObjectId(objToRemove));
                    SerDe$.MODULE$.writeInt(dos, 0);
                    SerDe$.MODULE$.writeObject(dos, null, this.server.jvmObjectTracker());
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Removing ").append(objId).append(" failed").toString(), e);
                    SerDe$.MODULE$.writeInt(dos, -1);
                    SerDe$.MODULE$.writeString(dos, new StringBuilder(18).append("Removing ").append(objId).append(" failed: ").append(e.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                dos.writeInt(-1);
                SerDe$.MODULE$.writeString(dos, new StringBuilder(22).append("Error: unknown method ").append(methodName).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            object = BoxedUnit.UNIT;
        } else {
            ScheduledExecutorService execService = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("SparkRKeepAliveThread");
            Runnable pingRunner = new Runnable(null, ctx){
                private final ChannelHandlerContext ctx$1;

                public void run() {
                    ByteArrayOutputStream pingBaos = new ByteArrayOutputStream();
                    DataOutputStream pingDaos = new DataOutputStream(pingBaos);
                    SerDe$.MODULE$.writeInt(pingDaos, 1);
                    this.ctx$1.write((Object)pingBaos.toByteArray());
                }
                {
                    this.ctx$1 = ctx$1;
                }
            };
            SparkConf conf = new SparkConf();
            int heartBeatInterval = conf.getInt("spark.r.heartBeatInterval", SparkRDefaults$.MODULE$.DEFAULT_HEARTBEAT_INTERVAL());
            int backendConnectionTimeout = conf.getInt("spark.r.backendConnectionTimeout", SparkRDefaults$.MODULE$.DEFAULT_CONNECTION_TIMEOUT());
            int interval = Math.min(heartBeatInterval, backendConnectionTimeout - 1);
            execService.scheduleAtFixedRate(pingRunner, interval, interval, TimeUnit.SECONDS);
            this.handleMethodCall(isStatic, objId, methodName, numArgs, dis, dos);
            execService.shutdown();
            object = BoxesRunTime.boxToBoolean((boolean)execService.awaitTermination(1L, TimeUnit.SECONDS));
        }
        byte[] reply = bos.toByteArray();
        ctx.write((Object)reply);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Throwable throwable = cause;
        if (throwable instanceof ReadTimeoutException) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring read timeout in RBackendHandler");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            cause.printStackTrace();
            ctx.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void handleMethodCall(boolean isStatic, String objId, String methodName, int numArgs, DataInputStream dis, DataOutputStream dos) {
        block8: {
            Object obj = null;
            try {
                Class<?> clazz;
                if (isStatic) {
                    clazz = Utils$.MODULE$.classForName(objId);
                } else {
                    obj = this.server.jvmObjectTracker().apply(new JVMObjectId(objId));
                    clazz = obj.getClass();
                }
                Class<?> cls = clazz;
                Object[] args = this.readArgs(numArgs, dis);
                Method[] methods = cls.getMethods();
                Method[] selectedMethods = (Method[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])methods)).filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RBackendHandler.$anonfun$handleMethodCall$1(methodName, m)));
                if (selectedMethods.length > 0) {
                    Option<Object> index = this.findMatchedSignature((Class[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedMethods)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getParameterTypes(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Class.class)))), args);
                    if (index.isEmpty()) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("cannot find matching method ").append(cls).append(".").append(methodName).append(". ").append("Candidates are:").toString());
                        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedMethods)).foreach((Function1 & Serializable & scala.Serializable)method -> {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(methodName$1).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])method.getParameterTypes())).mkString(",")).append(")").toString());
                            return BoxedUnit.UNIT;
                        });
                        throw new Exception(new StringBuilder(29).append("No matched method found for ").append(cls).append(".").append(methodName).toString());
                    }
                    Object ret = selectedMethods[BoxesRunTime.unboxToInt((Object)index.get())].invoke(obj, args);
                    SerDe$.MODULE$.writeInt(dos, 0);
                    SerDe$.MODULE$.writeObject(dos, ret, this.server.jvmObjectTracker());
                    break block8;
                }
                String string = methodName;
                String string2 = "<init>";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Constructor<?>[] ctors = cls.getConstructors();
                    Option<Object> index = this.findMatchedSignature((Class[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ctors)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getParameterTypes(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Class.class)))), args);
                    if (index.isEmpty()) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("cannot find matching constructor for ").append(cls).append(". ").append("Candidates are:").toString());
                        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ctors)).foreach((Function1 & Serializable & scala.Serializable)ctor -> {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(cls$1).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ctor.getParameterTypes())).mkString(",")).append(")").toString());
                            return BoxedUnit.UNIT;
                        });
                        throw new Exception(new StringBuilder(33).append("No matched constructor found for ").append(cls).toString());
                    }
                    Object obj2 = ctors[BoxesRunTime.unboxToInt((Object)index.get())].newInstance(args);
                    SerDe$.MODULE$.writeInt(dos, 0);
                    SerDe$.MODULE$.writeObject(dos, obj2, this.server.jvmObjectTracker());
                    break block8;
                }
                throw new IllegalArgumentException(new StringBuilder(27).append("invalid method ").append(methodName).append(" for object ").append(objId).toString());
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append(methodName).append(" on ").append(objId).append(" failed").toString(), e);
                SerDe$.MODULE$.writeInt(dos, -1);
                SerDe$.MODULE$.writeString(dos, Utils$.MODULE$.exceptionString(e.getCause()));
            }
        }
    }

    public Object[] readArgs(int numArgs, DataInputStream dis) {
        return (Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numArgs).map((Function1 & Serializable & scala.Serializable)x$3 -> SerDe$.MODULE$.readObject(dis, this.server.jvmObjectTracker()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
    }

    public Option<Object> findMatchedSignature(Class<?>[][] parameterTypesOfMethods, Object[] args) {
        Option option;
        Object object = new Object();
        try {
            int numArgs = args.length;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameterTypesOfMethods)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                Class[] parameterTypes = parameterTypesOfMethods[index];
                if (parameterTypes.length == numArgs) {
                    boolean argMatched = true;
                    for (int i2 = 0; i2 < numArgs && argMatched; ++i2) {
                        Class<Integer> parameterType;
                        Class<Integer> clazz = parameterType = parameterTypes[i2];
                        Class<Seq> clazz2 = Seq.class;
                        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) && args[i2].getClass().isArray()) continue;
                        Class<Integer> parameterWrapperType = parameterType;
                        if (parameterType.isPrimitive()) {
                            Class clazz3;
                            Class<Integer> clazz4 = parameterType;
                            Class<Integer> clazz5 = Integer.TYPE;
                            Class<Integer> clazz6 = clazz4;
                            if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
                                clazz3 = Integer.class;
                            } else {
                                Class<Long> clazz7 = Long.TYPE;
                                Class<Integer> clazz8 = clazz4;
                                if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
                                    clazz3 = Integer.class;
                                } else {
                                    Class<Double> clazz9 = Double.TYPE;
                                    Class<Integer> clazz10 = clazz4;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
                                        clazz3 = Double.class;
                                    } else {
                                        Class<Boolean> clazz11 = Boolean.TYPE;
                                        Class<Integer> clazz12 = clazz4;
                                        clazz3 = !(clazz11 != null ? !clazz11.equals(clazz12) : clazz12 != null) ? Boolean.class : parameterType;
                                    }
                                }
                            }
                            parameterWrapperType = clazz3;
                        }
                        if (!parameterType.isPrimitive() && args[i2] == null || parameterWrapperType.isInstance(args[i2])) continue;
                        argMatched = false;
                    }
                    if (argMatched) {
                        Class[] parameterTypes2 = parameterTypesOfMethods[index];
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numArgs).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                            block0: {
                                Class clazz = parameterTypes2[i];
                                Class<Seq> clazz2 = Seq.class;
                                if ((clazz != null ? !clazz.equals(clazz2) : clazz2 != null) || !args[i].getClass().isArray()) break block0;
                                args$1[i] = Predef$.MODULE$.genericArrayOps(args[i]).toSeq();
                            }
                        });
                        throw new NonLocalReturnControl(object, (Object)new Some((Object)BoxesRunTime.boxToInteger((int)index)));
                    }
                }
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$handleMethodCall$1(String methodName$1, Method m) {
        String string = m.getName();
        String string2 = methodName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public RBackendHandler(RBackend server) {
        this.server = server;
        Logging.$init$(this);
    }
}

