/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.python.Converter;
import org.apache.spark.api.python.Converter$;
import org.apache.spark.api.python.JavaToWritableConverter;
import org.apache.spark.api.python.PythonBroadcast;
import org.apache.spark.api.python.PythonHadoopUtil$;
import org.apache.spark.api.python.PythonServer$;
import org.apache.spark.api.python.SerDeUtil$;
import org.apache.spark.api.python.SpecialLengths$;
import org.apache.spark.api.python.WritableToJavaConverter;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.security.SocketAuthHelper;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.collection.mutable.WeakHashMap;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class PythonRDD$
implements Logging,
scala.Serializable {
    public static PythonRDD$ MODULE$;
    private SocketAuthHelper authHelper;
    private final WeakHashMap<Socket, Set<Object>> workerBroadcasts;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new PythonRDD$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    private WeakHashMap<Socket, Set<Object>> workerBroadcasts() {
        return this.workerBroadcasts;
    }

    private SocketAuthHelper authHelper$lzycompute() {
        PythonRDD$ pythonRDD$ = this;
        synchronized (pythonRDD$) {
            if (!this.bitmap$0) {
                SparkConf conf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.conf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new SparkConf());
                this.authHelper = new SocketAuthHelper(conf);
                this.bitmap$0 = true;
            }
        }
        return this.authHelper;
    }

    private SocketAuthHelper authHelper() {
        return !this.bitmap$0 ? this.authHelper$lzycompute() : this.authHelper;
    }

    public synchronized Set<Object> getWorkerBroadcasts(Socket worker) {
        return (Set)this.workerBroadcasts().getOrElseUpdate((Object)worker, (Function0 & Serializable & scala.Serializable)() -> new HashSet());
    }

    public JavaRDD<byte[]> valueOfPair(JavaPairRDD<Object, byte[]> pair) {
        return JavaRDD$.MODULE$.fromRDD(pair.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)it -> it.map((Function1 & Serializable & scala.Serializable)x$3 -> (byte[])x$3._2()), true, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public Object[] runJob(SparkContext sc, JavaRDD<byte[]> rdd, ArrayList<Object> partitions) {
        byte[][][] allPartitions = (byte[][][])sc.runJob(JavaRDD$.MODULE$.toRDD(rdd), (Function1 & Serializable & scala.Serializable)x -> (byte[][])x.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), (Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(partitions).asScala()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
        byte[][] flattenedPartition = (byte[][])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])allPartitions), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        return this.serveIterator(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])flattenedPartition)).iterator(), new StringBuilder(27).append("serve RDD ").append(rdd.id()).append(" with partitions ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(partitions).asScala()).mkString(",")).toString());
    }

    public <T> Object[] collectAndServe(RDD<T> rdd) {
        return this.serveIterator(Predef$.MODULE$.genericArrayOps(rdd.collect()).iterator(), new StringBuilder(10).append("serve RDD ").append(rdd.id()).toString());
    }

    public <T> Object[] toLocalIteratorAndServe(RDD<T> rdd) {
        return this.serveIterator(rdd.toLocalIterator(), "serve toLocalIterator");
    }

    public JavaRDD<byte[]> readRDDFromFile(JavaSparkContext sc, String filename, int parallelism) {
        return this.readRDDFromInputStream(sc.sc(), new FileInputStream(filename), parallelism);
    }

    public JavaRDD<byte[]> readRDDFromInputStream(SparkContext sc, InputStream in, int parallelism) {
        JavaRDD<byte[]> javaRDD;
        try (DataInputStream din = new DataInputStream(in);){
            ArrayBuffer objs = new ArrayBuffer();
            try {
                while (true) {
                    int length = din.readInt();
                    byte[] obj = new byte[length];
                    din.readFully(obj);
                    objs.$plus$eq((Object)obj);
                }
            }
            catch (EOFException eof) {
                javaRDD = JavaRDD$.MODULE$.fromRDD(sc.parallelize(objs, parallelism, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            }
        }
        return javaRDD;
    }

    public PythonBroadcast setupBroadcast(String path) {
        return new PythonBroadcast(path);
    }

    public <T> void writeIteratorToStream(Iterator<T> iter, DataOutputStream dataOut) {
        iter.foreach((Function1 & Serializable & scala.Serializable)obj -> {
            this.write$1(obj, dataOut);
            return BoxedUnit.UNIT;
        });
    }

    public <K, V> JavaRDD<byte[]> sequenceFile(JavaSparkContext sc, String path, String keyClassMaybeNull, String valueClassMaybeNull, String keyConverterClass, String valueConverterClass, int minSplits, int batchSize) {
        String keyClass = (String)Option$.MODULE$.apply((Object)keyClassMaybeNull).getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.apache.hadoop.io.Text");
        String valueClass = (String)Option$.MODULE$.apply((Object)valueClassMaybeNull).getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.apache.hadoop.io.Text");
        Class<?> kc = Utils$.MODULE$.classForName(keyClass);
        Class<?> vc = Utils$.MODULE$.classForName(valueClass);
        RDD<Tuple2<K, V>> rdd = sc.sc().sequenceFile(path, kc, vc, minSplits);
        Broadcast<SerializableConfiguration> confBroadcasted = sc.sc().broadcast(new SerializableConfiguration(sc.hadoopConfiguration()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        RDD<Tuple2<Object, Object>> converted = this.convertRDD(rdd, keyConverterClass, valueConverterClass, new WritableToJavaConverter(confBroadcasted));
        return JavaRDD$.MODULE$.fromRDD(SerDeUtil$.MODULE$.pairRDDToPython(converted, batchSize), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public <K, V, F extends InputFormat<K, V>> JavaRDD<byte[]> newAPIHadoopFile(JavaSparkContext sc, String path, String inputFormatClass, String keyClass, String valueClass, String keyConverterClass, String valueConverterClass, HashMap<String, String> confAsMap, int batchSize) {
        Configuration mergedConf = this.getMergedConf(confAsMap, sc.hadoopConfiguration());
        RDD<Tuple2<K, V>> rdd = this.newAPIHadoopRDDFromClassNames(sc, (Option<String>)new Some((Object)path), inputFormatClass, keyClass, valueClass, mergedConf);
        Broadcast<SerializableConfiguration> confBroadcasted = sc.sc().broadcast(new SerializableConfiguration(mergedConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        RDD<Tuple2<Object, Object>> converted = this.convertRDD(rdd, keyConverterClass, valueConverterClass, new WritableToJavaConverter(confBroadcasted));
        return JavaRDD$.MODULE$.fromRDD(SerDeUtil$.MODULE$.pairRDDToPython(converted, batchSize), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public <K, V, F extends InputFormat<K, V>> JavaRDD<byte[]> newAPIHadoopRDD(JavaSparkContext sc, String inputFormatClass, String keyClass, String valueClass, String keyConverterClass, String valueConverterClass, HashMap<String, String> confAsMap, int batchSize) {
        Configuration conf = PythonHadoopUtil$.MODULE$.mapToConf(confAsMap);
        RDD<Tuple2<K, V>> rdd = this.newAPIHadoopRDDFromClassNames(sc, (Option<String>)None$.MODULE$, inputFormatClass, keyClass, valueClass, conf);
        Broadcast<SerializableConfiguration> confBroadcasted = sc.sc().broadcast(new SerializableConfiguration(conf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        RDD<Tuple2<Object, Object>> converted = this.convertRDD(rdd, keyConverterClass, valueConverterClass, new WritableToJavaConverter(confBroadcasted));
        return JavaRDD$.MODULE$.fromRDD(SerDeUtil$.MODULE$.pairRDDToPython(converted, batchSize), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private <K, V, F extends InputFormat<K, V>> RDD<Tuple2<K, V>> newAPIHadoopRDDFromClassNames(JavaSparkContext sc, Option<String> path, String inputFormatClass, String keyClass, String valueClass, Configuration conf) {
        Class<?> kc = Utils$.MODULE$.classForName(keyClass);
        Class<?> vc = Utils$.MODULE$.classForName(valueClass);
        Class<?> fc = Utils$.MODULE$.classForName(inputFormatClass);
        return path.isDefined() ? sc.sc().newAPIHadoopFile((String)path.get(), fc, kc, vc, conf) : sc.sc().newAPIHadoopRDD(conf, fc, kc, vc);
    }

    private <K, V, F extends InputFormat<K, V>> Option<String> newAPIHadoopRDDFromClassNames$default$2() {
        return None$.MODULE$;
    }

    public <K, V, F extends org.apache.hadoop.mapred.InputFormat<K, V>> JavaRDD<byte[]> hadoopFile(JavaSparkContext sc, String path, String inputFormatClass, String keyClass, String valueClass, String keyConverterClass, String valueConverterClass, HashMap<String, String> confAsMap, int batchSize) {
        Configuration mergedConf = this.getMergedConf(confAsMap, sc.hadoopConfiguration());
        RDD<Tuple2<K, V>> rdd = this.hadoopRDDFromClassNames(sc, (Option<String>)new Some((Object)path), inputFormatClass, keyClass, valueClass, mergedConf);
        Broadcast<SerializableConfiguration> confBroadcasted = sc.sc().broadcast(new SerializableConfiguration(mergedConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        RDD<Tuple2<Object, Object>> converted = this.convertRDD(rdd, keyConverterClass, valueConverterClass, new WritableToJavaConverter(confBroadcasted));
        return JavaRDD$.MODULE$.fromRDD(SerDeUtil$.MODULE$.pairRDDToPython(converted, batchSize), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public <K, V, F extends org.apache.hadoop.mapred.InputFormat<K, V>> JavaRDD<byte[]> hadoopRDD(JavaSparkContext sc, String inputFormatClass, String keyClass, String valueClass, String keyConverterClass, String valueConverterClass, HashMap<String, String> confAsMap, int batchSize) {
        Configuration conf = PythonHadoopUtil$.MODULE$.mapToConf(confAsMap);
        RDD<Tuple2<K, V>> rdd = this.hadoopRDDFromClassNames(sc, (Option<String>)None$.MODULE$, inputFormatClass, keyClass, valueClass, conf);
        Broadcast<SerializableConfiguration> confBroadcasted = sc.sc().broadcast(new SerializableConfiguration(conf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        RDD<Tuple2<Object, Object>> converted = this.convertRDD(rdd, keyConverterClass, valueConverterClass, new WritableToJavaConverter(confBroadcasted));
        return JavaRDD$.MODULE$.fromRDD(SerDeUtil$.MODULE$.pairRDDToPython(converted, batchSize), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private <K, V, F extends org.apache.hadoop.mapred.InputFormat<K, V>> RDD<Tuple2<K, V>> hadoopRDDFromClassNames(JavaSparkContext sc, Option<String> path, String inputFormatClass, String keyClass, String valueClass, Configuration conf) {
        Class<?> kc = Utils$.MODULE$.classForName(keyClass);
        Class<?> vc = Utils$.MODULE$.classForName(valueClass);
        Class<?> fc = Utils$.MODULE$.classForName(inputFormatClass);
        return path.isDefined() ? sc.sc().hadoopFile((String)path.get(), fc, kc, vc, sc.sc().hadoopFile$default$5()) : sc.sc().hadoopRDD(new JobConf(conf), fc, kc, vc, sc.sc().hadoopRDD$default$5());
    }

    private <K, V, F extends org.apache.hadoop.mapred.InputFormat<K, V>> Option<String> hadoopRDDFromClassNames$default$2() {
        return None$.MODULE$;
    }

    public void writeUTF(String str, DataOutputStream dataOut) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        dataOut.write(bytes);
    }

    public Object[] serveIterator(Iterator<?> items, String threadName) {
        return this.serveToStream(threadName, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)out -> {
            PythonRDD$.MODULE$.writeIteratorToStream(items, new DataOutputStream(out));
            return BoxedUnit.UNIT;
        });
    }

    public Object[] serveToStream(String threadName, Function1<OutputStream, BoxedUnit> writeFunc) {
        Tuple2<Object, String> tuple2 = PythonServer$.MODULE$.setupOneConnectionServer(this.authHelper(), threadName, (Function1<Socket, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            PythonRDD$.$anonfun$serveToStream$1(writeFunc, s);
            return BoxedUnit.UNIT;
        });
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int port = tuple2._1$mcI$sp();
        String secret = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)port), (Object)secret);
        Tuple2 tuple23 = tuple22;
        int port2 = tuple23._1$mcI$sp();
        String secret2 = (String)tuple23._2();
        return (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port2), secret2}), ClassTag$.MODULE$.Any());
    }

    private Configuration getMergedConf(HashMap<String, String> confAsMap, Configuration baseConf) {
        Configuration conf = PythonHadoopUtil$.MODULE$.mapToConf(confAsMap);
        return PythonHadoopUtil$.MODULE$.mergeConfs(baseConf, conf);
    }

    private <K, V> Tuple2<Class<?>, Class<?>> inferKeyValueTypes(RDD<Tuple2<K, V>> rdd, String keyConverterClass, String valueConverterClass) {
        Tuple2<K, V> tuple2 = rdd.first();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object key = tuple2._1();
        Object value = tuple2._2();
        Tuple2 tuple22 = new Tuple2(key, value);
        Tuple2 tuple23 = tuple22;
        Object key2 = tuple23._1();
        Object value2 = tuple23._2();
        Tuple2<Converter<Object, Object>, Converter<Object, Object>> tuple24 = this.getKeyValueConverters(keyConverterClass, valueConverterClass, new JavaToWritableConverter());
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        Converter kc = (Converter)tuple24._1();
        Converter vc = (Converter)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)kc, (Object)vc);
        Tuple2 tuple26 = tuple25;
        Converter kc2 = (Converter)tuple26._1();
        Converter vc2 = (Converter)tuple26._2();
        return new Tuple2(kc2.convert(key2).getClass(), vc2.convert(value2).getClass());
    }

    private <K, V> String inferKeyValueTypes$default$2() {
        return null;
    }

    private <K, V> String inferKeyValueTypes$default$3() {
        return null;
    }

    private Option<Tuple2<Class<?>, Class<?>>> getKeyValueTypes(String keyClass, String valueClass) {
        return Option$.MODULE$.apply((Object)keyClass).flatMap((Function1 & Serializable & scala.Serializable)k -> Option$.MODULE$.apply((Object)valueClass).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(Utils$.MODULE$.classForName((String)k), Utils$.MODULE$.classForName((String)v))));
    }

    private Tuple2<Converter<Object, Object>, Converter<Object, Object>> getKeyValueConverters(String keyConverterClass, String valueConverterClass, Converter<Object, Object> defaultConverter) {
        Converter<Object, Object> keyConverter = Converter$.MODULE$.getInstance((Option<String>)Option$.MODULE$.apply((Object)keyConverterClass), defaultConverter);
        Converter<Object, Object> valueConverter = Converter$.MODULE$.getInstance((Option<String>)Option$.MODULE$.apply((Object)valueConverterClass), defaultConverter);
        return new Tuple2(keyConverter, valueConverter);
    }

    private <K, V> RDD<Tuple2<Object, Object>> convertRDD(RDD<Tuple2<K, V>> rdd, String keyConverterClass, String valueConverterClass, Converter<Object, Object> defaultConverter) {
        Tuple2<Converter<Object, Object>, Converter<Object, Object>> tuple2 = this.getKeyValueConverters(keyConverterClass, valueConverterClass, defaultConverter);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Converter kc = (Converter)tuple2._1();
        Converter vc = (Converter)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)kc, (Object)vc);
        Tuple2 tuple23 = tuple22;
        Converter kc2 = (Converter)tuple23._1();
        Converter vc2 = (Converter)tuple23._2();
        return PythonHadoopUtil$.MODULE$.convertRDD(rdd, kc2, vc2);
    }

    public <K, V, C extends CompressionCodec> void saveAsSequenceFile(JavaRDD<byte[]> pyRDD, boolean batchSerialized, String path, String compressionCodecClass) {
        this.saveAsHadoopFile(pyRDD, batchSerialized, path, "org.apache.hadoop.mapred.SequenceFileOutputFormat", null, null, null, null, new HashMap<String, String>(), compressionCodecClass);
    }

    public <K, V, F extends OutputFormat<?, ?>, C extends CompressionCodec> void saveAsHadoopFile(JavaRDD<byte[]> pyRDD, boolean batchSerialized, String path, String outputFormatClass, String keyClass, String valueClass, String keyConverterClass, String valueConverterClass, HashMap<String, String> confAsMap, String compressionCodecClass) {
        RDD rdd = SerDeUtil$.MODULE$.pythonToPairRDD(JavaRDD$.MODULE$.toRDD(pyRDD), batchSerialized);
        Tuple2 tuple2 = (Tuple2)this.getKeyValueTypes(keyClass, valueClass).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.inferKeyValueTypes(rdd, keyConverterClass, valueConverterClass));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class kc = (Class)tuple2._1();
        Class vc = (Class)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)kc, (Object)vc);
        Tuple2 tuple23 = tuple22;
        Class kc2 = (Class)tuple23._1();
        Class vc2 = (Class)tuple23._2();
        Configuration mergedConf = this.getMergedConf(confAsMap, pyRDD.context().hadoopConfiguration());
        Option codec = Option$.MODULE$.apply((Object)compressionCodecClass).map((Function1 & Serializable & scala.Serializable)x$9 -> Utils$.MODULE$.classForName((String)x$9));
        RDD converted = this.convertRDD(rdd, keyConverterClass, valueConverterClass, new JavaToWritableConverter());
        Class<?> fc = Utils$.MODULE$.classForName(outputFormatClass);
        RDD x$12 = converted;
        ClassTag x$13 = ClassTag$.MODULE$.Any();
        ClassTag x$14 = ClassTag$.MODULE$.Any();
        Null$ x$15 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$12);
        RDD$.MODULE$.rddToPairRDDFunctions(x$12, x$13, x$14, null).saveAsHadoopFile(path, kc2, vc2, fc, new JobConf(mergedConf), (Option<Class<CompressionCodec>>)codec);
    }

    public <K, V, F extends org.apache.hadoop.mapreduce.OutputFormat<?, ?>> void saveAsNewAPIHadoopFile(JavaRDD<byte[]> pyRDD, boolean batchSerialized, String path, String outputFormatClass, String keyClass, String valueClass, String keyConverterClass, String valueConverterClass, HashMap<String, String> confAsMap) {
        RDD rdd = SerDeUtil$.MODULE$.pythonToPairRDD(JavaRDD$.MODULE$.toRDD(pyRDD), batchSerialized);
        Tuple2 tuple2 = (Tuple2)this.getKeyValueTypes(keyClass, valueClass).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.inferKeyValueTypes(rdd, keyConverterClass, valueConverterClass));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class kc = (Class)tuple2._1();
        Class vc = (Class)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)kc, (Object)vc);
        Tuple2 tuple23 = tuple22;
        Class kc2 = (Class)tuple23._1();
        Class vc2 = (Class)tuple23._2();
        Configuration mergedConf = this.getMergedConf(confAsMap, pyRDD.context().hadoopConfiguration());
        RDD converted = this.convertRDD(rdd, keyConverterClass, valueConverterClass, new JavaToWritableConverter());
        Class<?> fc = Utils$.MODULE$.classForName(outputFormatClass);
        RDD x$16 = converted;
        ClassTag x$17 = ClassTag$.MODULE$.Any();
        ClassTag x$18 = ClassTag$.MODULE$.Any();
        Null$ x$19 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$16);
        RDD$.MODULE$.rddToPairRDDFunctions(x$16, x$17, x$18, null).saveAsNewAPIHadoopFile(path, kc2, vc2, fc, mergedConf);
    }

    public <K, V> void saveAsHadoopDataset(JavaRDD<byte[]> pyRDD, boolean batchSerialized, HashMap<String, String> confAsMap, String keyConverterClass, String valueConverterClass, boolean useNewAPI) {
        Configuration conf = PythonHadoopUtil$.MODULE$.mapToConf(confAsMap);
        RDD converted = this.convertRDD(SerDeUtil$.MODULE$.pythonToPairRDD(JavaRDD$.MODULE$.toRDD(pyRDD), batchSerialized), keyConverterClass, valueConverterClass, new JavaToWritableConverter());
        if (useNewAPI) {
            RDD x$20 = converted;
            ClassTag x$21 = ClassTag$.MODULE$.Any();
            ClassTag x$22 = ClassTag$.MODULE$.Any();
            Null$ x$23 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$20);
            RDD$.MODULE$.rddToPairRDDFunctions(x$20, x$21, x$22, null).saveAsNewAPIHadoopDataset(conf);
        } else {
            RDD x$24 = converted;
            ClassTag x$25 = ClassTag$.MODULE$.Any();
            ClassTag x$26 = ClassTag$.MODULE$.Any();
            Null$ x$27 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$24);
            RDD$.MODULE$.rddToPairRDDFunctions(x$24, x$25, x$26, null).saveAsHadoopDataset(new JobConf(conf));
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final void write$1(Object obj, DataOutputStream dataOut$1) {
        block5: {
            Object object;
            while (true) {
                if ((object = obj) == null) {
                    dataOut$1.writeInt(SpecialLengths$.MODULE$.NULL());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    dataOut$1.writeInt(byArray.length);
                    dataOut$1.write(byArray);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (object instanceof String) {
                    String string = (String)object;
                    this.writeUTF(string, dataOut$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (object instanceof PortableDataStream) {
                    PortableDataStream portableDataStream = (PortableDataStream)object;
                    obj = portableDataStream.toArray();
                    continue;
                }
                if (!(object instanceof Tuple2)) break;
                Tuple2 tuple2 = (Tuple2)object;
                Object key = tuple2._1();
                Object value = tuple2._2();
                this.write$1(key, dataOut$1);
                obj = value;
            }
            throw new SparkException(new StringBuilder(24).append("Unexpected element type ").append(object.getClass()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$serveToStream$1(Function1 writeFunc$1, Socket s) {
        BufferedOutputStream out = new BufferedOutputStream(s.getOutputStream());
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writeFunc$1.apply((Object)out), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
    }

    private PythonRDD$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.workerBroadcasts = new WeakHashMap();
    }
}

