/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.voicepermission;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.voicepermission.Country;

public class CountryReader
extends Reader<Country> {
    private String isoCode;
    private String continent;
    private String countryCode;
    private Boolean lowRiskNumbersEnabled;
    private Boolean highRiskSpecialNumbersEnabled;
    private Boolean highRiskTollfraudNumbersEnabled;

    public CountryReader setIsoCode(String isoCode) {
        this.isoCode = isoCode;
        return this;
    }

    public CountryReader setContinent(String continent) {
        this.continent = continent;
        return this;
    }

    public CountryReader setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public CountryReader setLowRiskNumbersEnabled(Boolean lowRiskNumbersEnabled) {
        this.lowRiskNumbersEnabled = lowRiskNumbersEnabled;
        return this;
    }

    public CountryReader setHighRiskSpecialNumbersEnabled(Boolean highRiskSpecialNumbersEnabled) {
        this.highRiskSpecialNumbersEnabled = highRiskSpecialNumbersEnabled;
        return this;
    }

    public CountryReader setHighRiskTollfraudNumbersEnabled(Boolean highRiskTollfraudNumbersEnabled) {
        this.highRiskTollfraudNumbersEnabled = highRiskTollfraudNumbersEnabled;
        return this;
    }

    @Override
    public ResourceSet<Country> read(TwilioRestClient client) {
        return new ResourceSet<Country>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Country> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VOICE.toString(), "/v1/DialingPermissions/Countries", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Country> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Country> nextPage(Page<Country> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VOICE.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Country> previousPage(Page<Country> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VOICE.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Country> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Country read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("content", response.getContent(), Country.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.isoCode != null) {
            request.addQueryParam("IsoCode", this.isoCode);
        }
        if (this.continent != null) {
            request.addQueryParam("Continent", this.continent);
        }
        if (this.countryCode != null) {
            request.addQueryParam("CountryCode", this.countryCode);
        }
        if (this.lowRiskNumbersEnabled != null) {
            request.addQueryParam("LowRiskNumbersEnabled", this.lowRiskNumbersEnabled.toString());
        }
        if (this.highRiskSpecialNumbersEnabled != null) {
            request.addQueryParam("HighRiskSpecialNumbersEnabled", this.highRiskSpecialNumbersEnabled.toString());
        }
        if (this.highRiskTollfraudNumbersEnabled != null) {
            request.addQueryParam("HighRiskTollfraudNumbersEnabled", this.highRiskTollfraudNumbersEnabled.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

