/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Task;

public class TaskCreator
extends Creator<Task> {
    private final String pathWorkspaceSid;
    private Integer timeout;
    private Integer priority;
    private String taskChannel;
    private String workflowSid;
    private String attributes;

    public TaskCreator(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public TaskCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public TaskCreator setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public TaskCreator setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    public TaskCreator setWorkflowSid(String workflowSid) {
        this.workflowSid = workflowSid;
        return this;
    }

    public TaskCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public Task create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Tasks", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
        if (this.taskChannel != null) {
            request.addPostParam("TaskChannel", this.taskChannel);
        }
        if (this.workflowSid != null) {
            request.addPostParam("WorkflowSid", this.workflowSid);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

