/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.synclist;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.synclist.SyncListItem;
import java.util.Map;

public class SyncListItemUpdater
extends Updater<SyncListItem> {
    private final String pathServiceSid;
    private final String pathListSid;
    private final Integer pathIndex;
    private Map<String, Object> data;
    private Integer ttl;
    private Integer itemTtl;
    private Integer collectionTtl;

    public SyncListItemUpdater(String pathServiceSid, String pathListSid, Integer pathIndex) {
        this.pathServiceSid = pathServiceSid;
        this.pathListSid = pathListSid;
        this.pathIndex = pathIndex;
    }

    public SyncListItemUpdater setData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public SyncListItemUpdater setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public SyncListItemUpdater setItemTtl(Integer itemTtl) {
        this.itemTtl = itemTtl;
        return this;
    }

    public SyncListItemUpdater setCollectionTtl(Integer collectionTtl) {
        this.collectionTtl = collectionTtl;
        return this;
    }

    @Override
    public SyncListItem update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SYNC.toString(), "/v1/Services/" + this.pathServiceSid + "/Lists/" + this.pathListSid + "/Items/" + this.pathIndex + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncListItem update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return SyncListItem.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.data != null) {
            request.addPostParam("Data", Converter.mapToJson(this.data));
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
        if (this.itemTtl != null) {
            request.addPostParam("ItemTtl", this.itemTtl.toString());
        }
        if (this.collectionTtl != null) {
            request.addPostParam("CollectionTtl", this.collectionTtl.toString());
        }
    }
}

