/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.sync.v1.service.SyncListCreator;
import com.twilio.rest.sync.v1.service.SyncListDeleter;
import com.twilio.rest.sync.v1.service.SyncListFetcher;
import com.twilio.rest.sync.v1.service.SyncListReader;
import com.twilio.rest.sync.v1.service.SyncListUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SyncList
extends Resource {
    private static final long serialVersionUID = 113063121662943L;
    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final String serviceSid;
    private final URI url;
    private final Map<String, String> links;
    private final String revision;
    private final DateTime dateExpires;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String createdBy;

    public static SyncListFetcher fetcher(String pathServiceSid, String pathSid) {
        return new SyncListFetcher(pathServiceSid, pathSid);
    }

    public static SyncListDeleter deleter(String pathServiceSid, String pathSid) {
        return new SyncListDeleter(pathServiceSid, pathSid);
    }

    public static SyncListCreator creator(String pathServiceSid) {
        return new SyncListCreator(pathServiceSid);
    }

    public static SyncListUpdater updater(String pathServiceSid, String pathSid) {
        return new SyncListUpdater(pathServiceSid, pathSid);
    }

    public static SyncListReader reader(String pathServiceSid) {
        return new SyncListReader(pathServiceSid);
    }

    public static SyncList fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SyncList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SyncList fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SyncList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SyncList(@JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="revision") String revision, @JsonProperty(value="date_expires") String dateExpires, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="created_by") String createdBy) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.url = url;
        this.links = links;
        this.revision = revision;
        this.dateExpires = DateConverter.iso8601DateTimeFromString(dateExpires);
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.createdBy = createdBy;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final String getRevision() {
        return this.revision;
    }

    public final DateTime getDateExpires() {
        return this.dateExpires;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getCreatedBy() {
        return this.createdBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncList other = (SyncList)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.revision, other.revision) && Objects.equals(this.dateExpires, other.dateExpires) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.createdBy, other.createdBy);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.uniqueName, this.accountSid, this.serviceSid, this.url, this.links, this.revision, this.dateExpires, this.dateCreated, this.dateUpdated, this.createdBy);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("uniqueName", this.uniqueName).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("url", this.url).add("links", this.links).add("revision", this.revision).add("dateExpires", this.dateExpires).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("createdBy", this.createdBy).toString();
    }
}

