/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.PhoneNumber;

public class PhoneNumberUpdater
extends Updater<PhoneNumber> {
    private final String pathServiceSid;
    private final String pathSid;
    private Boolean isReserved;

    public PhoneNumberUpdater(String pathServiceSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    public PhoneNumberUpdater setIsReserved(Boolean isReserved) {
        this.isReserved = isReserved;
        return this;
    }

    @Override
    public PhoneNumber update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PROXY.toString(), "/v1/Services/" + this.pathServiceSid + "/PhoneNumbers/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PhoneNumber update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.isReserved != null) {
            request.addPostParam("IsReserved", this.isReserved.toString());
        }
    }
}

