/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1.service.channel;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v1.service.channel.Member;
import java.util.List;

public class MemberReader
extends Reader<Member> {
    private final String pathServiceSid;
    private final String pathChannelSid;
    private List<String> identity;

    public MemberReader(String pathServiceSid, String pathChannelSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
    }

    public MemberReader setIdentity(List<String> identity) {
        this.identity = identity;
        return this;
    }

    public MemberReader setIdentity(String identity) {
        return this.setIdentity(Promoter.listOfOne(identity));
    }

    @Override
    public ResourceSet<Member> read(TwilioRestClient client) {
        return new ResourceSet<Member>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Member> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.IPMESSAGING.toString(), "/v1/Services/" + this.pathServiceSid + "/Channels/" + this.pathChannelSid + "/Members", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Member> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Member> nextPage(Page<Member> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.IPMESSAGING.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Member> previousPage(Page<Member> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.IPMESSAGING.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Member> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("members", response.getContent(), Member.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.identity != null) {
            for (String prop : this.identity) {
                request.addQueryParam("Identity", prop);
            }
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

