/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v1;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v1.Service;
import java.net.URI;
import java.util.List;

public class ServiceUpdater
extends Updater<Service> {
    private final String pathSid;
    private String friendlyName;
    private String defaultServiceRoleSid;
    private String defaultChannelRoleSid;
    private String defaultChannelCreatorRoleSid;
    private Boolean readStatusEnabled;
    private Boolean reachabilityEnabled;
    private Integer typingIndicatorTimeout;
    private Integer consumptionReportInterval;
    private Boolean notificationsNewMessageEnabled;
    private String notificationsNewMessageTemplate;
    private Boolean notificationsAddedToChannelEnabled;
    private String notificationsAddedToChannelTemplate;
    private Boolean notificationsRemovedFromChannelEnabled;
    private String notificationsRemovedFromChannelTemplate;
    private Boolean notificationsInvitedToChannelEnabled;
    private String notificationsInvitedToChannelTemplate;
    private URI preWebhookUrl;
    private URI postWebhookUrl;
    private HttpMethod webhookMethod;
    private List<String> webhookFilters;
    private URI webhooksOnMessageSendUrl;
    private HttpMethod webhooksOnMessageSendMethod;
    private String webhooksOnMessageSendFormat;
    private URI webhooksOnMessageUpdateUrl;
    private HttpMethod webhooksOnMessageUpdateMethod;
    private String webhooksOnMessageUpdateFormat;
    private URI webhooksOnMessageRemoveUrl;
    private HttpMethod webhooksOnMessageRemoveMethod;
    private String webhooksOnMessageRemoveFormat;
    private URI webhooksOnChannelAddUrl;
    private HttpMethod webhooksOnChannelAddMethod;
    private String webhooksOnChannelAddFormat;
    private URI webhooksOnChannelDestroyUrl;
    private HttpMethod webhooksOnChannelDestroyMethod;
    private String webhooksOnChannelDestroyFormat;
    private URI webhooksOnChannelUpdateUrl;
    private HttpMethod webhooksOnChannelUpdateMethod;
    private String webhooksOnChannelUpdateFormat;
    private URI webhooksOnMemberAddUrl;
    private HttpMethod webhooksOnMemberAddMethod;
    private String webhooksOnMemberAddFormat;
    private URI webhooksOnMemberRemoveUrl;
    private HttpMethod webhooksOnMemberRemoveMethod;
    private String webhooksOnMemberRemoveFormat;
    private URI webhooksOnMessageSentUrl;
    private HttpMethod webhooksOnMessageSentMethod;
    private String webhooksOnMessageSentFormat;
    private URI webhooksOnMessageUpdatedUrl;
    private HttpMethod webhooksOnMessageUpdatedMethod;
    private String webhooksOnMessageUpdatedFormat;
    private URI webhooksOnMessageRemovedUrl;
    private HttpMethod webhooksOnMessageRemovedMethod;
    private String webhooksOnMessageRemovedFormat;
    private URI webhooksOnChannelAddedUrl;
    private HttpMethod webhooksOnChannelAddedMethod;
    private String webhooksOnChannelAddedFormat;
    private URI webhooksOnChannelDestroyedUrl;
    private HttpMethod webhooksOnChannelDestroyedMethod;
    private String webhooksOnChannelDestroyedFormat;
    private URI webhooksOnChannelUpdatedUrl;
    private HttpMethod webhooksOnChannelUpdatedMethod;
    private String webhooksOnChannelUpdatedFormat;
    private URI webhooksOnMemberAddedUrl;
    private HttpMethod webhooksOnMemberAddedMethod;
    private String webhooksOnMemberAddedFormat;
    private URI webhooksOnMemberRemovedUrl;
    private HttpMethod webhooksOnMemberRemovedMethod;
    private String webhooksOnMemberRemovedFormat;
    private Integer limitsChannelMembers;
    private Integer limitsUserChannels;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setDefaultServiceRoleSid(String defaultServiceRoleSid) {
        this.defaultServiceRoleSid = defaultServiceRoleSid;
        return this;
    }

    public ServiceUpdater setDefaultChannelRoleSid(String defaultChannelRoleSid) {
        this.defaultChannelRoleSid = defaultChannelRoleSid;
        return this;
    }

    public ServiceUpdater setDefaultChannelCreatorRoleSid(String defaultChannelCreatorRoleSid) {
        this.defaultChannelCreatorRoleSid = defaultChannelCreatorRoleSid;
        return this;
    }

    public ServiceUpdater setReadStatusEnabled(Boolean readStatusEnabled) {
        this.readStatusEnabled = readStatusEnabled;
        return this;
    }

    public ServiceUpdater setReachabilityEnabled(Boolean reachabilityEnabled) {
        this.reachabilityEnabled = reachabilityEnabled;
        return this;
    }

    public ServiceUpdater setTypingIndicatorTimeout(Integer typingIndicatorTimeout) {
        this.typingIndicatorTimeout = typingIndicatorTimeout;
        return this;
    }

    public ServiceUpdater setConsumptionReportInterval(Integer consumptionReportInterval) {
        this.consumptionReportInterval = consumptionReportInterval;
        return this;
    }

    public ServiceUpdater setNotificationsNewMessageEnabled(Boolean notificationsNewMessageEnabled) {
        this.notificationsNewMessageEnabled = notificationsNewMessageEnabled;
        return this;
    }

    public ServiceUpdater setNotificationsNewMessageTemplate(String notificationsNewMessageTemplate) {
        this.notificationsNewMessageTemplate = notificationsNewMessageTemplate;
        return this;
    }

    public ServiceUpdater setNotificationsAddedToChannelEnabled(Boolean notificationsAddedToChannelEnabled) {
        this.notificationsAddedToChannelEnabled = notificationsAddedToChannelEnabled;
        return this;
    }

    public ServiceUpdater setNotificationsAddedToChannelTemplate(String notificationsAddedToChannelTemplate) {
        this.notificationsAddedToChannelTemplate = notificationsAddedToChannelTemplate;
        return this;
    }

    public ServiceUpdater setNotificationsRemovedFromChannelEnabled(Boolean notificationsRemovedFromChannelEnabled) {
        this.notificationsRemovedFromChannelEnabled = notificationsRemovedFromChannelEnabled;
        return this;
    }

    public ServiceUpdater setNotificationsRemovedFromChannelTemplate(String notificationsRemovedFromChannelTemplate) {
        this.notificationsRemovedFromChannelTemplate = notificationsRemovedFromChannelTemplate;
        return this;
    }

    public ServiceUpdater setNotificationsInvitedToChannelEnabled(Boolean notificationsInvitedToChannelEnabled) {
        this.notificationsInvitedToChannelEnabled = notificationsInvitedToChannelEnabled;
        return this;
    }

    public ServiceUpdater setNotificationsInvitedToChannelTemplate(String notificationsInvitedToChannelTemplate) {
        this.notificationsInvitedToChannelTemplate = notificationsInvitedToChannelTemplate;
        return this;
    }

    public ServiceUpdater setPreWebhookUrl(URI preWebhookUrl) {
        this.preWebhookUrl = preWebhookUrl;
        return this;
    }

    public ServiceUpdater setPreWebhookUrl(String preWebhookUrl) {
        return this.setPreWebhookUrl(Promoter.uriFromString(preWebhookUrl));
    }

    public ServiceUpdater setPostWebhookUrl(URI postWebhookUrl) {
        this.postWebhookUrl = postWebhookUrl;
        return this;
    }

    public ServiceUpdater setPostWebhookUrl(String postWebhookUrl) {
        return this.setPostWebhookUrl(Promoter.uriFromString(postWebhookUrl));
    }

    public ServiceUpdater setWebhookMethod(HttpMethod webhookMethod) {
        this.webhookMethod = webhookMethod;
        return this;
    }

    public ServiceUpdater setWebhookFilters(List<String> webhookFilters) {
        this.webhookFilters = webhookFilters;
        return this;
    }

    public ServiceUpdater setWebhookFilters(String webhookFilters) {
        return this.setWebhookFilters(Promoter.listOfOne(webhookFilters));
    }

    public ServiceUpdater setWebhooksOnMessageSendUrl(URI webhooksOnMessageSendUrl) {
        this.webhooksOnMessageSendUrl = webhooksOnMessageSendUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageSendUrl(String webhooksOnMessageSendUrl) {
        return this.setWebhooksOnMessageSendUrl(Promoter.uriFromString(webhooksOnMessageSendUrl));
    }

    public ServiceUpdater setWebhooksOnMessageSendMethod(HttpMethod webhooksOnMessageSendMethod) {
        this.webhooksOnMessageSendMethod = webhooksOnMessageSendMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageSendFormat(String webhooksOnMessageSendFormat) {
        this.webhooksOnMessageSendFormat = webhooksOnMessageSendFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageUpdateUrl(URI webhooksOnMessageUpdateUrl) {
        this.webhooksOnMessageUpdateUrl = webhooksOnMessageUpdateUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageUpdateUrl(String webhooksOnMessageUpdateUrl) {
        return this.setWebhooksOnMessageUpdateUrl(Promoter.uriFromString(webhooksOnMessageUpdateUrl));
    }

    public ServiceUpdater setWebhooksOnMessageUpdateMethod(HttpMethod webhooksOnMessageUpdateMethod) {
        this.webhooksOnMessageUpdateMethod = webhooksOnMessageUpdateMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageUpdateFormat(String webhooksOnMessageUpdateFormat) {
        this.webhooksOnMessageUpdateFormat = webhooksOnMessageUpdateFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageRemoveUrl(URI webhooksOnMessageRemoveUrl) {
        this.webhooksOnMessageRemoveUrl = webhooksOnMessageRemoveUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageRemoveUrl(String webhooksOnMessageRemoveUrl) {
        return this.setWebhooksOnMessageRemoveUrl(Promoter.uriFromString(webhooksOnMessageRemoveUrl));
    }

    public ServiceUpdater setWebhooksOnMessageRemoveMethod(HttpMethod webhooksOnMessageRemoveMethod) {
        this.webhooksOnMessageRemoveMethod = webhooksOnMessageRemoveMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageRemoveFormat(String webhooksOnMessageRemoveFormat) {
        this.webhooksOnMessageRemoveFormat = webhooksOnMessageRemoveFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelAddUrl(URI webhooksOnChannelAddUrl) {
        this.webhooksOnChannelAddUrl = webhooksOnChannelAddUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelAddUrl(String webhooksOnChannelAddUrl) {
        return this.setWebhooksOnChannelAddUrl(Promoter.uriFromString(webhooksOnChannelAddUrl));
    }

    public ServiceUpdater setWebhooksOnChannelAddMethod(HttpMethod webhooksOnChannelAddMethod) {
        this.webhooksOnChannelAddMethod = webhooksOnChannelAddMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelAddFormat(String webhooksOnChannelAddFormat) {
        this.webhooksOnChannelAddFormat = webhooksOnChannelAddFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelDestroyUrl(URI webhooksOnChannelDestroyUrl) {
        this.webhooksOnChannelDestroyUrl = webhooksOnChannelDestroyUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelDestroyUrl(String webhooksOnChannelDestroyUrl) {
        return this.setWebhooksOnChannelDestroyUrl(Promoter.uriFromString(webhooksOnChannelDestroyUrl));
    }

    public ServiceUpdater setWebhooksOnChannelDestroyMethod(HttpMethod webhooksOnChannelDestroyMethod) {
        this.webhooksOnChannelDestroyMethod = webhooksOnChannelDestroyMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelDestroyFormat(String webhooksOnChannelDestroyFormat) {
        this.webhooksOnChannelDestroyFormat = webhooksOnChannelDestroyFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelUpdateUrl(URI webhooksOnChannelUpdateUrl) {
        this.webhooksOnChannelUpdateUrl = webhooksOnChannelUpdateUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelUpdateUrl(String webhooksOnChannelUpdateUrl) {
        return this.setWebhooksOnChannelUpdateUrl(Promoter.uriFromString(webhooksOnChannelUpdateUrl));
    }

    public ServiceUpdater setWebhooksOnChannelUpdateMethod(HttpMethod webhooksOnChannelUpdateMethod) {
        this.webhooksOnChannelUpdateMethod = webhooksOnChannelUpdateMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelUpdateFormat(String webhooksOnChannelUpdateFormat) {
        this.webhooksOnChannelUpdateFormat = webhooksOnChannelUpdateFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberAddUrl(URI webhooksOnMemberAddUrl) {
        this.webhooksOnMemberAddUrl = webhooksOnMemberAddUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberAddUrl(String webhooksOnMemberAddUrl) {
        return this.setWebhooksOnMemberAddUrl(Promoter.uriFromString(webhooksOnMemberAddUrl));
    }

    public ServiceUpdater setWebhooksOnMemberAddMethod(HttpMethod webhooksOnMemberAddMethod) {
        this.webhooksOnMemberAddMethod = webhooksOnMemberAddMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberAddFormat(String webhooksOnMemberAddFormat) {
        this.webhooksOnMemberAddFormat = webhooksOnMemberAddFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberRemoveUrl(URI webhooksOnMemberRemoveUrl) {
        this.webhooksOnMemberRemoveUrl = webhooksOnMemberRemoveUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberRemoveUrl(String webhooksOnMemberRemoveUrl) {
        return this.setWebhooksOnMemberRemoveUrl(Promoter.uriFromString(webhooksOnMemberRemoveUrl));
    }

    public ServiceUpdater setWebhooksOnMemberRemoveMethod(HttpMethod webhooksOnMemberRemoveMethod) {
        this.webhooksOnMemberRemoveMethod = webhooksOnMemberRemoveMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberRemoveFormat(String webhooksOnMemberRemoveFormat) {
        this.webhooksOnMemberRemoveFormat = webhooksOnMemberRemoveFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageSentUrl(URI webhooksOnMessageSentUrl) {
        this.webhooksOnMessageSentUrl = webhooksOnMessageSentUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageSentUrl(String webhooksOnMessageSentUrl) {
        return this.setWebhooksOnMessageSentUrl(Promoter.uriFromString(webhooksOnMessageSentUrl));
    }

    public ServiceUpdater setWebhooksOnMessageSentMethod(HttpMethod webhooksOnMessageSentMethod) {
        this.webhooksOnMessageSentMethod = webhooksOnMessageSentMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageSentFormat(String webhooksOnMessageSentFormat) {
        this.webhooksOnMessageSentFormat = webhooksOnMessageSentFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageUpdatedUrl(URI webhooksOnMessageUpdatedUrl) {
        this.webhooksOnMessageUpdatedUrl = webhooksOnMessageUpdatedUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageUpdatedUrl(String webhooksOnMessageUpdatedUrl) {
        return this.setWebhooksOnMessageUpdatedUrl(Promoter.uriFromString(webhooksOnMessageUpdatedUrl));
    }

    public ServiceUpdater setWebhooksOnMessageUpdatedMethod(HttpMethod webhooksOnMessageUpdatedMethod) {
        this.webhooksOnMessageUpdatedMethod = webhooksOnMessageUpdatedMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageUpdatedFormat(String webhooksOnMessageUpdatedFormat) {
        this.webhooksOnMessageUpdatedFormat = webhooksOnMessageUpdatedFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageRemovedUrl(URI webhooksOnMessageRemovedUrl) {
        this.webhooksOnMessageRemovedUrl = webhooksOnMessageRemovedUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageRemovedUrl(String webhooksOnMessageRemovedUrl) {
        return this.setWebhooksOnMessageRemovedUrl(Promoter.uriFromString(webhooksOnMessageRemovedUrl));
    }

    public ServiceUpdater setWebhooksOnMessageRemovedMethod(HttpMethod webhooksOnMessageRemovedMethod) {
        this.webhooksOnMessageRemovedMethod = webhooksOnMessageRemovedMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMessageRemovedFormat(String webhooksOnMessageRemovedFormat) {
        this.webhooksOnMessageRemovedFormat = webhooksOnMessageRemovedFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelAddedUrl(URI webhooksOnChannelAddedUrl) {
        this.webhooksOnChannelAddedUrl = webhooksOnChannelAddedUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelAddedUrl(String webhooksOnChannelAddedUrl) {
        return this.setWebhooksOnChannelAddedUrl(Promoter.uriFromString(webhooksOnChannelAddedUrl));
    }

    public ServiceUpdater setWebhooksOnChannelAddedMethod(HttpMethod webhooksOnChannelAddedMethod) {
        this.webhooksOnChannelAddedMethod = webhooksOnChannelAddedMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelAddedFormat(String webhooksOnChannelAddedFormat) {
        this.webhooksOnChannelAddedFormat = webhooksOnChannelAddedFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelDestroyedUrl(URI webhooksOnChannelDestroyedUrl) {
        this.webhooksOnChannelDestroyedUrl = webhooksOnChannelDestroyedUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelDestroyedUrl(String webhooksOnChannelDestroyedUrl) {
        return this.setWebhooksOnChannelDestroyedUrl(Promoter.uriFromString(webhooksOnChannelDestroyedUrl));
    }

    public ServiceUpdater setWebhooksOnChannelDestroyedMethod(HttpMethod webhooksOnChannelDestroyedMethod) {
        this.webhooksOnChannelDestroyedMethod = webhooksOnChannelDestroyedMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelDestroyedFormat(String webhooksOnChannelDestroyedFormat) {
        this.webhooksOnChannelDestroyedFormat = webhooksOnChannelDestroyedFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelUpdatedUrl(URI webhooksOnChannelUpdatedUrl) {
        this.webhooksOnChannelUpdatedUrl = webhooksOnChannelUpdatedUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelUpdatedUrl(String webhooksOnChannelUpdatedUrl) {
        return this.setWebhooksOnChannelUpdatedUrl(Promoter.uriFromString(webhooksOnChannelUpdatedUrl));
    }

    public ServiceUpdater setWebhooksOnChannelUpdatedMethod(HttpMethod webhooksOnChannelUpdatedMethod) {
        this.webhooksOnChannelUpdatedMethod = webhooksOnChannelUpdatedMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnChannelUpdatedFormat(String webhooksOnChannelUpdatedFormat) {
        this.webhooksOnChannelUpdatedFormat = webhooksOnChannelUpdatedFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberAddedUrl(URI webhooksOnMemberAddedUrl) {
        this.webhooksOnMemberAddedUrl = webhooksOnMemberAddedUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberAddedUrl(String webhooksOnMemberAddedUrl) {
        return this.setWebhooksOnMemberAddedUrl(Promoter.uriFromString(webhooksOnMemberAddedUrl));
    }

    public ServiceUpdater setWebhooksOnMemberAddedMethod(HttpMethod webhooksOnMemberAddedMethod) {
        this.webhooksOnMemberAddedMethod = webhooksOnMemberAddedMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberAddedFormat(String webhooksOnMemberAddedFormat) {
        this.webhooksOnMemberAddedFormat = webhooksOnMemberAddedFormat;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberRemovedUrl(URI webhooksOnMemberRemovedUrl) {
        this.webhooksOnMemberRemovedUrl = webhooksOnMemberRemovedUrl;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberRemovedUrl(String webhooksOnMemberRemovedUrl) {
        return this.setWebhooksOnMemberRemovedUrl(Promoter.uriFromString(webhooksOnMemberRemovedUrl));
    }

    public ServiceUpdater setWebhooksOnMemberRemovedMethod(HttpMethod webhooksOnMemberRemovedMethod) {
        this.webhooksOnMemberRemovedMethod = webhooksOnMemberRemovedMethod;
        return this;
    }

    public ServiceUpdater setWebhooksOnMemberRemovedFormat(String webhooksOnMemberRemovedFormat) {
        this.webhooksOnMemberRemovedFormat = webhooksOnMemberRemovedFormat;
        return this;
    }

    public ServiceUpdater setLimitsChannelMembers(Integer limitsChannelMembers) {
        this.limitsChannelMembers = limitsChannelMembers;
        return this;
    }

    public ServiceUpdater setLimitsUserChannels(Integer limitsUserChannels) {
        this.limitsUserChannels = limitsUserChannels;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), "/v1/Services/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.defaultServiceRoleSid != null) {
            request.addPostParam("DefaultServiceRoleSid", this.defaultServiceRoleSid);
        }
        if (this.defaultChannelRoleSid != null) {
            request.addPostParam("DefaultChannelRoleSid", this.defaultChannelRoleSid);
        }
        if (this.defaultChannelCreatorRoleSid != null) {
            request.addPostParam("DefaultChannelCreatorRoleSid", this.defaultChannelCreatorRoleSid);
        }
        if (this.readStatusEnabled != null) {
            request.addPostParam("ReadStatusEnabled", this.readStatusEnabled.toString());
        }
        if (this.reachabilityEnabled != null) {
            request.addPostParam("ReachabilityEnabled", this.reachabilityEnabled.toString());
        }
        if (this.typingIndicatorTimeout != null) {
            request.addPostParam("TypingIndicatorTimeout", this.typingIndicatorTimeout.toString());
        }
        if (this.consumptionReportInterval != null) {
            request.addPostParam("ConsumptionReportInterval", this.consumptionReportInterval.toString());
        }
        if (this.notificationsNewMessageEnabled != null) {
            request.addPostParam("Notifications.NewMessage.Enabled", this.notificationsNewMessageEnabled.toString());
        }
        if (this.notificationsNewMessageTemplate != null) {
            request.addPostParam("Notifications.NewMessage.Template", this.notificationsNewMessageTemplate);
        }
        if (this.notificationsAddedToChannelEnabled != null) {
            request.addPostParam("Notifications.AddedToChannel.Enabled", this.notificationsAddedToChannelEnabled.toString());
        }
        if (this.notificationsAddedToChannelTemplate != null) {
            request.addPostParam("Notifications.AddedToChannel.Template", this.notificationsAddedToChannelTemplate);
        }
        if (this.notificationsRemovedFromChannelEnabled != null) {
            request.addPostParam("Notifications.RemovedFromChannel.Enabled", this.notificationsRemovedFromChannelEnabled.toString());
        }
        if (this.notificationsRemovedFromChannelTemplate != null) {
            request.addPostParam("Notifications.RemovedFromChannel.Template", this.notificationsRemovedFromChannelTemplate);
        }
        if (this.notificationsInvitedToChannelEnabled != null) {
            request.addPostParam("Notifications.InvitedToChannel.Enabled", this.notificationsInvitedToChannelEnabled.toString());
        }
        if (this.notificationsInvitedToChannelTemplate != null) {
            request.addPostParam("Notifications.InvitedToChannel.Template", this.notificationsInvitedToChannelTemplate);
        }
        if (this.preWebhookUrl != null) {
            request.addPostParam("PreWebhookUrl", this.preWebhookUrl.toString());
        }
        if (this.postWebhookUrl != null) {
            request.addPostParam("PostWebhookUrl", this.postWebhookUrl.toString());
        }
        if (this.webhookMethod != null) {
            request.addPostParam("WebhookMethod", this.webhookMethod.toString());
        }
        if (this.webhookFilters != null) {
            for (String prop : this.webhookFilters) {
                request.addPostParam("WebhookFilters", prop);
            }
        }
        if (this.webhooksOnMessageSendUrl != null) {
            request.addPostParam("Webhooks.OnMessageSend.Url", this.webhooksOnMessageSendUrl.toString());
        }
        if (this.webhooksOnMessageSendMethod != null) {
            request.addPostParam("Webhooks.OnMessageSend.Method", this.webhooksOnMessageSendMethod.toString());
        }
        if (this.webhooksOnMessageSendFormat != null) {
            request.addPostParam("Webhooks.OnMessageSend.Format", this.webhooksOnMessageSendFormat);
        }
        if (this.webhooksOnMessageUpdateUrl != null) {
            request.addPostParam("Webhooks.OnMessageUpdate.Url", this.webhooksOnMessageUpdateUrl.toString());
        }
        if (this.webhooksOnMessageUpdateMethod != null) {
            request.addPostParam("Webhooks.OnMessageUpdate.Method", this.webhooksOnMessageUpdateMethod.toString());
        }
        if (this.webhooksOnMessageUpdateFormat != null) {
            request.addPostParam("Webhooks.OnMessageUpdate.Format", this.webhooksOnMessageUpdateFormat);
        }
        if (this.webhooksOnMessageRemoveUrl != null) {
            request.addPostParam("Webhooks.OnMessageRemove.Url", this.webhooksOnMessageRemoveUrl.toString());
        }
        if (this.webhooksOnMessageRemoveMethod != null) {
            request.addPostParam("Webhooks.OnMessageRemove.Method", this.webhooksOnMessageRemoveMethod.toString());
        }
        if (this.webhooksOnMessageRemoveFormat != null) {
            request.addPostParam("Webhooks.OnMessageRemove.Format", this.webhooksOnMessageRemoveFormat);
        }
        if (this.webhooksOnChannelAddUrl != null) {
            request.addPostParam("Webhooks.OnChannelAdd.Url", this.webhooksOnChannelAddUrl.toString());
        }
        if (this.webhooksOnChannelAddMethod != null) {
            request.addPostParam("Webhooks.OnChannelAdd.Method", this.webhooksOnChannelAddMethod.toString());
        }
        if (this.webhooksOnChannelAddFormat != null) {
            request.addPostParam("Webhooks.OnChannelAdd.Format", this.webhooksOnChannelAddFormat);
        }
        if (this.webhooksOnChannelDestroyUrl != null) {
            request.addPostParam("Webhooks.OnChannelDestroy.Url", this.webhooksOnChannelDestroyUrl.toString());
        }
        if (this.webhooksOnChannelDestroyMethod != null) {
            request.addPostParam("Webhooks.OnChannelDestroy.Method", this.webhooksOnChannelDestroyMethod.toString());
        }
        if (this.webhooksOnChannelDestroyFormat != null) {
            request.addPostParam("Webhooks.OnChannelDestroy.Format", this.webhooksOnChannelDestroyFormat);
        }
        if (this.webhooksOnChannelUpdateUrl != null) {
            request.addPostParam("Webhooks.OnChannelUpdate.Url", this.webhooksOnChannelUpdateUrl.toString());
        }
        if (this.webhooksOnChannelUpdateMethod != null) {
            request.addPostParam("Webhooks.OnChannelUpdate.Method", this.webhooksOnChannelUpdateMethod.toString());
        }
        if (this.webhooksOnChannelUpdateFormat != null) {
            request.addPostParam("Webhooks.OnChannelUpdate.Format", this.webhooksOnChannelUpdateFormat);
        }
        if (this.webhooksOnMemberAddUrl != null) {
            request.addPostParam("Webhooks.OnMemberAdd.Url", this.webhooksOnMemberAddUrl.toString());
        }
        if (this.webhooksOnMemberAddMethod != null) {
            request.addPostParam("Webhooks.OnMemberAdd.Method", this.webhooksOnMemberAddMethod.toString());
        }
        if (this.webhooksOnMemberAddFormat != null) {
            request.addPostParam("Webhooks.OnMemberAdd.Format", this.webhooksOnMemberAddFormat);
        }
        if (this.webhooksOnMemberRemoveUrl != null) {
            request.addPostParam("Webhooks.OnMemberRemove.Url", this.webhooksOnMemberRemoveUrl.toString());
        }
        if (this.webhooksOnMemberRemoveMethod != null) {
            request.addPostParam("Webhooks.OnMemberRemove.Method", this.webhooksOnMemberRemoveMethod.toString());
        }
        if (this.webhooksOnMemberRemoveFormat != null) {
            request.addPostParam("Webhooks.OnMemberRemove.Format", this.webhooksOnMemberRemoveFormat);
        }
        if (this.webhooksOnMessageSentUrl != null) {
            request.addPostParam("Webhooks.OnMessageSent.Url", this.webhooksOnMessageSentUrl.toString());
        }
        if (this.webhooksOnMessageSentMethod != null) {
            request.addPostParam("Webhooks.OnMessageSent.Method", this.webhooksOnMessageSentMethod.toString());
        }
        if (this.webhooksOnMessageSentFormat != null) {
            request.addPostParam("Webhooks.OnMessageSent.Format", this.webhooksOnMessageSentFormat);
        }
        if (this.webhooksOnMessageUpdatedUrl != null) {
            request.addPostParam("Webhooks.OnMessageUpdated.Url", this.webhooksOnMessageUpdatedUrl.toString());
        }
        if (this.webhooksOnMessageUpdatedMethod != null) {
            request.addPostParam("Webhooks.OnMessageUpdated.Method", this.webhooksOnMessageUpdatedMethod.toString());
        }
        if (this.webhooksOnMessageUpdatedFormat != null) {
            request.addPostParam("Webhooks.OnMessageUpdated.Format", this.webhooksOnMessageUpdatedFormat);
        }
        if (this.webhooksOnMessageRemovedUrl != null) {
            request.addPostParam("Webhooks.OnMessageRemoved.Url", this.webhooksOnMessageRemovedUrl.toString());
        }
        if (this.webhooksOnMessageRemovedMethod != null) {
            request.addPostParam("Webhooks.OnMessageRemoved.Method", this.webhooksOnMessageRemovedMethod.toString());
        }
        if (this.webhooksOnMessageRemovedFormat != null) {
            request.addPostParam("Webhooks.OnMessageRemoved.Format", this.webhooksOnMessageRemovedFormat);
        }
        if (this.webhooksOnChannelAddedUrl != null) {
            request.addPostParam("Webhooks.OnChannelAdded.Url", this.webhooksOnChannelAddedUrl.toString());
        }
        if (this.webhooksOnChannelAddedMethod != null) {
            request.addPostParam("Webhooks.OnChannelAdded.Method", this.webhooksOnChannelAddedMethod.toString());
        }
        if (this.webhooksOnChannelAddedFormat != null) {
            request.addPostParam("Webhooks.OnChannelAdded.Format", this.webhooksOnChannelAddedFormat);
        }
        if (this.webhooksOnChannelDestroyedUrl != null) {
            request.addPostParam("Webhooks.OnChannelDestroyed.Url", this.webhooksOnChannelDestroyedUrl.toString());
        }
        if (this.webhooksOnChannelDestroyedMethod != null) {
            request.addPostParam("Webhooks.OnChannelDestroyed.Method", this.webhooksOnChannelDestroyedMethod.toString());
        }
        if (this.webhooksOnChannelDestroyedFormat != null) {
            request.addPostParam("Webhooks.OnChannelDestroyed.Format", this.webhooksOnChannelDestroyedFormat);
        }
        if (this.webhooksOnChannelUpdatedUrl != null) {
            request.addPostParam("Webhooks.OnChannelUpdated.Url", this.webhooksOnChannelUpdatedUrl.toString());
        }
        if (this.webhooksOnChannelUpdatedMethod != null) {
            request.addPostParam("Webhooks.OnChannelUpdated.Method", this.webhooksOnChannelUpdatedMethod.toString());
        }
        if (this.webhooksOnChannelUpdatedFormat != null) {
            request.addPostParam("Webhooks.OnChannelUpdated.Format", this.webhooksOnChannelUpdatedFormat);
        }
        if (this.webhooksOnMemberAddedUrl != null) {
            request.addPostParam("Webhooks.OnMemberAdded.Url", this.webhooksOnMemberAddedUrl.toString());
        }
        if (this.webhooksOnMemberAddedMethod != null) {
            request.addPostParam("Webhooks.OnMemberAdded.Method", this.webhooksOnMemberAddedMethod.toString());
        }
        if (this.webhooksOnMemberAddedFormat != null) {
            request.addPostParam("Webhooks.OnMemberAdded.Format", this.webhooksOnMemberAddedFormat);
        }
        if (this.webhooksOnMemberRemovedUrl != null) {
            request.addPostParam("Webhooks.OnMemberRemoved.Url", this.webhooksOnMemberRemovedUrl.toString());
        }
        if (this.webhooksOnMemberRemovedMethod != null) {
            request.addPostParam("Webhooks.OnMemberRemoved.Method", this.webhooksOnMemberRemovedMethod.toString());
        }
        if (this.webhooksOnMemberRemovedFormat != null) {
            request.addPostParam("Webhooks.OnMemberRemoved.Format", this.webhooksOnMemberRemovedFormat);
        }
        if (this.limitsChannelMembers != null) {
            request.addPostParam("Limits.ChannelMembers", this.limitsChannelMembers.toString());
        }
        if (this.limitsUserChannels != null) {
            request.addPostParam("Limits.UserChannels", this.limitsUserChannels.toString());
        }
    }
}

