/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1.service.entity.factor;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.authy.v1.service.entity.factor.Challenge;

public class ChallengeFetcher
extends Fetcher<Challenge> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final String pathFactorSid;
    private final String pathSid;

    public ChallengeFetcher(String pathServiceSid, String pathIdentity, String pathFactorSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathFactorSid = pathFactorSid;
        this.pathSid = pathSid;
    }

    @Override
    public Challenge fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.AUTHY.toString(), "/v1/Services/" + this.pathServiceSid + "/Entities/" + this.pathIdentity + "/Factors/" + this.pathFactorSid + "/Challenges/" + this.pathSid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Challenge fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Challenge.fromJson(response.getStream(), client.getObjectMapper());
    }
}

