/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.message;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.message.Media;

public class MediaDeleter
extends Deleter<Media> {
    private String pathAccountSid;
    private final String pathMessageSid;
    private final String pathSid;

    public MediaDeleter(String pathMessageSid, String pathSid) {
        this.pathMessageSid = pathMessageSid;
        this.pathSid = pathSid;
    }

    public MediaDeleter(String pathAccountSid, String pathMessageSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathMessageSid = pathMessageSid;
        this.pathSid = pathSid;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.DELETE, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Messages/" + this.pathMessageSid + "/Media/" + this.pathSid + ".json", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Media delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return response.getStatusCode() == 204;
    }
}

