/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.conference.ParticipantCreator;
import com.twilio.rest.api.v2010.account.conference.ParticipantDeleter;
import com.twilio.rest.api.v2010.account.conference.ParticipantFetcher;
import com.twilio.rest.api.v2010.account.conference.ParticipantReader;
import com.twilio.rest.api.v2010.account.conference.ParticipantUpdater;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends Resource {
    private static final long serialVersionUID = 246599390416338L;
    private final String accountSid;
    private final String callSid;
    private final String conferenceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Boolean endConferenceOnExit;
    private final Boolean muted;
    private final Boolean hold;
    private final Boolean startConferenceOnEnter;
    private final Status status;
    private final String uri;

    public static ParticipantFetcher fetcher(String pathAccountSid, String pathConferenceSid, String pathCallSid) {
        return new ParticipantFetcher(pathAccountSid, pathConferenceSid, pathCallSid);
    }

    public static ParticipantFetcher fetcher(String pathConferenceSid, String pathCallSid) {
        return new ParticipantFetcher(pathConferenceSid, pathCallSid);
    }

    public static ParticipantUpdater updater(String pathAccountSid, String pathConferenceSid, String pathCallSid) {
        return new ParticipantUpdater(pathAccountSid, pathConferenceSid, pathCallSid);
    }

    public static ParticipantUpdater updater(String pathConferenceSid, String pathCallSid) {
        return new ParticipantUpdater(pathConferenceSid, pathCallSid);
    }

    public static ParticipantCreator creator(String pathAccountSid, String pathConferenceSid, PhoneNumber from, PhoneNumber to) {
        return new ParticipantCreator(pathAccountSid, pathConferenceSid, from, to);
    }

    public static ParticipantCreator creator(String pathConferenceSid, PhoneNumber from, PhoneNumber to) {
        return new ParticipantCreator(pathConferenceSid, from, to);
    }

    public static ParticipantDeleter deleter(String pathAccountSid, String pathConferenceSid, String pathCallSid) {
        return new ParticipantDeleter(pathAccountSid, pathConferenceSid, pathCallSid);
    }

    public static ParticipantDeleter deleter(String pathConferenceSid, String pathCallSid) {
        return new ParticipantDeleter(pathConferenceSid, pathCallSid);
    }

    public static ParticipantReader reader(String pathAccountSid, String pathConferenceSid) {
        return new ParticipantReader(pathAccountSid, pathConferenceSid);
    }

    public static ParticipantReader reader(String pathConferenceSid) {
        return new ParticipantReader(pathConferenceSid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="conference_sid") String conferenceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="end_conference_on_exit") Boolean endConferenceOnExit, @JsonProperty(value="muted") Boolean muted, @JsonProperty(value="hold") Boolean hold, @JsonProperty(value="start_conference_on_enter") Boolean startConferenceOnEnter, @JsonProperty(value="status") Status status, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.conferenceSid = conferenceSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.endConferenceOnExit = endConferenceOnExit;
        this.muted = muted;
        this.hold = hold;
        this.startConferenceOnEnter = startConferenceOnEnter;
        this.status = status;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getConferenceSid() {
        return this.conferenceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Boolean getEndConferenceOnExit() {
        return this.endConferenceOnExit;
    }

    public final Boolean getMuted() {
        return this.muted;
    }

    public final Boolean getHold() {
        return this.hold;
    }

    public final Boolean getStartConferenceOnEnter() {
        return this.startConferenceOnEnter;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.conferenceSid, other.conferenceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.endConferenceOnExit, other.endConferenceOnExit) && Objects.equals(this.muted, other.muted) && Objects.equals(this.hold, other.hold) && Objects.equals(this.startConferenceOnEnter, other.startConferenceOnEnter) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.callSid, this.conferenceSid, this.dateCreated, this.dateUpdated, this.endConferenceOnExit, this.muted, this.hold, this.startConferenceOnEnter, this.status, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("callSid", this.callSid).add("conferenceSid", this.conferenceSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("endConferenceOnExit", this.endConferenceOnExit).add("muted", this.muted).add("hold", this.hold).add("startConferenceOnEnter", this.startConferenceOnEnter).add("status", (Object)this.status).add("uri", this.uri).toString();
    }

    public static enum Status {
        QUEUED("queued"),
        CONNECTING("connecting"),
        RINGING("ringing"),
        CONNECTED("connected"),
        COMPLETE("complete"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

