/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.sql.Date;
import java.util.TimeZone;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.DateType;
import org.jadira.usertype.spi.shared.AbstractColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.timezone.proxy.TimeZoneProvidingSharedSessionContractImplementor;

public abstract class AbstractDateColumnMapper<T>
extends AbstractColumnMapper<T, Date>
implements DatabaseZoneConfigured {
    private static final long serialVersionUID = -8841076386862845448L;
    private TimeZone databaseZone;

    public final DateType getHibernateType() {
        return DateType.INSTANCE;
    }

    @Override
    public final int getSqlType() {
        return 91;
    }

    @Override
    public abstract T fromNonNullValue(Date var1);

    @Override
    public abstract T fromNonNullString(String var1);

    @Override
    public abstract Date toNonNullValue(T var1);

    @Override
    public abstract String toNonNullString(T var1);

    @Override
    public void setDatabaseZone(TimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    @Override
    public TimeZone parseZone(String zoneString) {
        return TimeZone.getTimeZone(zoneString);
    }

    @Override
    public TimeZone getDatabaseZone() {
        return this.databaseZone;
    }

    @Override
    public SharedSessionContractImplementor wrapSession(SharedSessionContractImplementor session) {
        SharedSessionContractImplementor mySession = this.databaseZone != null ? new TimeZoneProvidingSharedSessionContractImplementor(session, this.databaseZone) : session;
        return mySession;
    }
}

