/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCacheSubnetGroupRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String cacheSubnetGroupName;
    private String cacheSubnetGroupDescription;
    private List<String> subnetIds;

    public String getCacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public void setCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
    }

    public CreateCacheSubnetGroupRequest withCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
        return this;
    }

    public String getCacheSubnetGroupDescription() {
        return this.cacheSubnetGroupDescription;
    }

    public void setCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
        this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
    }

    public CreateCacheSubnetGroupRequest withCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
        this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
        return this;
    }

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            this.subnetIds = new ArrayList<String>();
        }
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        ArrayList<String> subnetIdsCopy = new ArrayList<String>(subnetIds.size());
        subnetIdsCopy.addAll(subnetIds);
        this.subnetIds = subnetIdsCopy;
    }

    public CreateCacheSubnetGroupRequest withSubnetIds(String ... subnetIds) {
        if (this.getSubnetIds() == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String value : subnetIds) {
            this.getSubnetIds().add(value);
        }
        return this;
    }

    public CreateCacheSubnetGroupRequest withSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
        } else {
            ArrayList<String> subnetIdsCopy = new ArrayList<String>(subnetIds.size());
            subnetIdsCopy.addAll(subnetIds);
            this.subnetIds = subnetIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: " + this.getCacheSubnetGroupName() + ", ");
        }
        if (this.getCacheSubnetGroupDescription() != null) {
            sb.append("CacheSubnetGroupDescription: " + this.getCacheSubnetGroupDescription() + ", ");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: " + this.getSubnetIds() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupName() == null ? 0 : this.getCacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupDescription() == null ? 0 : this.getCacheSubnetGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : ((Object)this.getSubnetIds()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheSubnetGroupRequest)) {
            return false;
        }
        CreateCacheSubnetGroupRequest other = (CreateCacheSubnetGroupRequest)obj;
        if (other.getCacheSubnetGroupName() == null ^ this.getCacheSubnetGroupName() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupName() != null && !other.getCacheSubnetGroupName().equals(this.getCacheSubnetGroupName())) {
            return false;
        }
        if (other.getCacheSubnetGroupDescription() == null ^ this.getCacheSubnetGroupDescription() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupDescription() != null && !other.getCacheSubnetGroupDescription().equals(this.getCacheSubnetGroupDescription())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        return other.getSubnetIds() == null || ((Object)other.getSubnetIds()).equals(this.getSubnetIds());
    }
}

