package models;

import models.contacts.FinancialInfo;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import play.db.jpa.Model;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;

/**
 * Created by dom on 4/12/2018.
 */
@Entity
public class Company extends Model {

    @Column(name="title", nullable=false, length=100)
    public String title;

    @Embedded
    public ContactInfo contactInfo= new ContactInfo();

    @Embedded
    public FinancialInfo financialInfo;
    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime registrationDate;


    public Company()
    {

    }
    public Company(String title , DateTime registrationDate, String district, String address, String number, String zipcode, String email, String landline, String worknumber, String fax, String mobile)
    {
        this.title = title;
        this.registrationDate = registrationDate;
        this.contactInfo = new ContactInfo(district, address, number, zipcode, email,landline, worknumber, fax, mobile);
    }

    @Override
    public String toString() {
        return title;
    }
}
