/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.autopilot.v1.assistant.task.SampleCreator;
import com.twilio.rest.autopilot.v1.assistant.task.SampleDeleter;
import com.twilio.rest.autopilot.v1.assistant.task.SampleFetcher;
import com.twilio.rest.autopilot.v1.assistant.task.SampleReader;
import com.twilio.rest.autopilot.v1.assistant.task.SampleUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Sample
extends Resource {
    private static final long serialVersionUID = 250546054765914L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String taskSid;
    private final String language;
    private final String assistantSid;
    private final String sid;
    private final String taggedText;
    private final URI url;
    private final String sourceChannel;

    public static SampleFetcher fetcher(String pathAssistantSid, String pathTaskSid, String pathSid) {
        return new SampleFetcher(pathAssistantSid, pathTaskSid, pathSid);
    }

    public static SampleReader reader(String pathAssistantSid, String pathTaskSid) {
        return new SampleReader(pathAssistantSid, pathTaskSid);
    }

    public static SampleCreator creator(String pathAssistantSid, String pathTaskSid, String language, String taggedText) {
        return new SampleCreator(pathAssistantSid, pathTaskSid, language, taggedText);
    }

    public static SampleUpdater updater(String pathAssistantSid, String pathTaskSid, String pathSid) {
        return new SampleUpdater(pathAssistantSid, pathTaskSid, pathSid);
    }

    public static SampleDeleter deleter(String pathAssistantSid, String pathTaskSid, String pathSid) {
        return new SampleDeleter(pathAssistantSid, pathTaskSid, pathSid);
    }

    public static Sample fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Sample.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Sample fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Sample.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Sample(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="task_sid") String taskSid, @JsonProperty(value="language") String language, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="tagged_text") String taggedText, @JsonProperty(value="url") URI url, @JsonProperty(value="source_channel") String sourceChannel) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.taskSid = taskSid;
        this.language = language;
        this.assistantSid = assistantSid;
        this.sid = sid;
        this.taggedText = taggedText;
        this.url = url;
        this.sourceChannel = sourceChannel;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getTaskSid() {
        return this.taskSid;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTaggedText() {
        return this.taggedText;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getSourceChannel() {
        return this.sourceChannel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sample other = (Sample)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.taskSid, other.taskSid) && Objects.equals(this.language, other.language) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.taggedText, other.taggedText) && Objects.equals(this.url, other.url) && Objects.equals(this.sourceChannel, other.sourceChannel);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.taskSid, this.language, this.assistantSid, this.sid, this.taggedText, this.url, this.sourceChannel);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("taskSid", this.taskSid).add("language", this.language).add("assistantSid", this.assistantSid).add("sid", this.sid).add("taggedText", this.taggedText).add("url", this.url).add("sourceChannel", this.sourceChannel).toString();
    }
}

