/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1.service.entity.factor;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.authy.v1.service.entity.factor.Challenge;

public class ChallengeUpdater
extends Updater<Challenge> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final String pathFactorSid;
    private final String pathSid;
    private String authPayload;

    public ChallengeUpdater(String pathServiceSid, String pathIdentity, String pathFactorSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathFactorSid = pathFactorSid;
        this.pathSid = pathSid;
    }

    public ChallengeUpdater setAuthPayload(String authPayload) {
        this.authPayload = authPayload;
        return this;
    }

    @Override
    public Challenge update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTHY.toString(), "/v1/Services/" + this.pathServiceSid + "/Entities/" + this.pathIdentity + "/Factors/" + this.pathFactorSid + "/Challenges/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Challenge update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Challenge.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.authPayload != null) {
            request.addPostParam("AuthPayload", this.authPayload);
        }
    }
}

