/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage.memory;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfoManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.memory.BlockEvictionHandler;
import org.apache.spark.storage.memory.DeserializedMemoryEntry;
import org.apache.spark.storage.memory.DeserializedValuesHolder;
import org.apache.spark.storage.memory.MemoryEntry;
import org.apache.spark.storage.memory.MemoryEntryBuilder;
import org.apache.spark.storage.memory.PartiallySerializedBlock;
import org.apache.spark.storage.memory.PartiallyUnrolledIterator;
import org.apache.spark.storage.memory.SerializedMemoryEntry;
import org.apache.spark.storage.memory.SerializedValuesHolder;
import org.apache.spark.storage.memory.ValuesHolder;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t]e!B\u0001\u0003\u0001\u0019a!aC'f[>\u0014\u0018p\u0015;pe\u0016T!a\u0001\u0003\u0002\r5,Wn\u001c:z\u0015\t)a!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011AcF\u0007\u0002+)\u0011aCB\u0001\tS:$XM\u001d8bY&\u0011\u0001$\u0006\u0002\b\u0019><w-\u001b8h\u0011!Q\u0002A!A!\u0002\u0013a\u0012\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002\u001e=5\ta!\u0003\u0002 \r\tI1\u000b]1sW\u000e{gN\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005\u0001\"\r\\8dW&sgm\\'b]\u0006<WM\u001d\t\u0003G\u0011j\u0011\u0001B\u0005\u0003K\u0011\u0011\u0001C\u00117pG.LeNZ8NC:\fw-\u001a:\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\n\u0011c]3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s!\tIC&D\u0001+\u0015\tYc!\u0001\u0006tKJL\u0017\r\\5{KJL!!\f\u0016\u0003#M+'/[1mSj,'/T1oC\u001e,'\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00035iW-\\8ss6\u000bg.Y4feB\u0011\u0011gM\u0007\u0002e)\u00111AB\u0005\u0003iI\u0012Q\"T3n_JLX*\u00198bO\u0016\u0014\b\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002)\tdwnY6Fm&\u001cG/[8o\u0011\u0006tG\r\\3s!\tA\u0014(D\u0001\u0003\u0013\tQ$A\u0001\u000bCY>\u001c7.\u0012<jGRLwN\u001c%b]\u0012dWM\u001d\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\ryz\u0004)\u0011\"D!\tA\u0004\u0001C\u0003\u001bw\u0001\u0007A\u0004C\u0003\"w\u0001\u0007!\u0005C\u0003(w\u0001\u0007\u0001\u0006C\u00030w\u0001\u0007\u0001\u0007C\u00037w\u0001\u0007q\u0007C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u000f\u0015tGO]5fgV\tq\t\u0005\u0003I\u001b>\u0013V\"A%\u000b\u0005)[\u0015\u0001B;uS2T\u0011\u0001T\u0001\u0005U\u00064\u0018-\u0003\u0002O\u0013\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\"a\t)\n\u0005E#!a\u0002\"m_\u000e\\\u0017\n\u001a\u0019\u0003'b\u00032\u0001\u000f+W\u0013\t)&AA\u0006NK6|'/_#oiJL\bCA,Y\u0019\u0001!\u0011\"\u0017.\u0002\u0002\u0003\u0005)\u0011\u0001/\u0003\u0007}#\u0013\u0007\u0003\u0004\\\u0001\u0001\u0006IaR\u0001\tK:$(/[3tAE\u0011Q\f\u0019\t\u0003\u001dyK!aX\b\u0003\u000f9{G\u000f[5oOB\u0011a\"Y\u0005\u0003E>\u00111!\u00118z\u0011\u001d!\u0007A1A\u0005\n\u0015\fQc\u001c8IK\u0006\u0004XK\u001c:pY2lU-\\8ss6\u000b\u0007/F\u0001g!\u00119GN\u001c8\u000e\u0003!T!!\u001b6\u0002\u000f5,H/\u00192mK*\u00111nD\u0001\u000bG>dG.Z2uS>t\u0017BA7i\u0005\u001dA\u0015m\u001d5NCB\u0004\"AD8\n\u0005A|!\u0001\u0002'p]\u001eDaA\u001d\u0001!\u0002\u00131\u0017AF8o\u0011\u0016\f\u0007/\u00168s_2dW*Z7pefl\u0015\r\u001d\u0011\t\u000fQ\u0004!\u0019!C\u0005K\u00061rN\u001a4IK\u0006\u0004XK\u001c:pY2lU-\\8ss6\u000b\u0007\u000f\u0003\u0004w\u0001\u0001\u0006IAZ\u0001\u0018_\u001a4\u0007*Z1q+:\u0014x\u000e\u001c7NK6|'/_'ba\u0002Bq\u0001\u001f\u0001C\u0002\u0013%\u00110A\u000bv]J|G\u000e\\'f[>\u0014\u0018\u0010\u00165sKNDw\u000e\u001c3\u0016\u00039Daa\u001f\u0001!\u0002\u0013q\u0017AF;oe>dG.T3n_JLH\u000b\u001b:fg\"|G\u000e\u001a\u0011\t\u000bu\u0004A\u0011B=\u0002\u00135\f\u00070T3n_JL\b\"B@\u0001\t\u0013I\u0018AC7f[>\u0014\u00180V:fI\"1\u00111\u0001\u0001\u0005\ne\f\u0001C\u00197pG.\u001cX*Z7pef,6/\u001a3\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u00059q-\u001a;TSj,Gc\u00018\u0002\f!9\u0011QBA\u0003\u0001\u0004y\u0015a\u00022m_\u000e\\\u0017\n\u001a\u0005\b\u0003#\u0001A\u0011AA\n\u0003!\u0001X\u000f\u001e\"zi\u0016\u001cX\u0003BA\u000b\u0003c!\"\"a\u0006\u00026\u0005]\u00121HA#)\u0011\tI\"a\b\u0011\u00079\tY\"C\u0002\u0002\u001e=\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002\"\u0005=\u0011\u0011!a\u0002\u0003G\t!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\t)#a\u000b\u000205\u0011\u0011q\u0005\u0006\u0004\u0003Sy\u0011a\u0002:fM2,7\r^\u0005\u0005\u0003[\t9C\u0001\u0005DY\u0006\u001c8\u000fV1h!\r9\u0016\u0011\u0007\u0003\b\u0003g\tyA1\u0001]\u0005\u0005!\u0006bBA\u0007\u0003\u001f\u0001\ra\u0014\u0005\b\u0003s\ty\u00011\u0001o\u0003\u0011\u0019\u0018N_3\t\u0011\u0005u\u0012q\u0002a\u0001\u0003\u007f\t!\"\\3n_JLXj\u001c3f!\r\t\u0014\u0011I\u0005\u0004\u0003\u0007\u0012$AC'f[>\u0014\u00180T8eK\"A\u0011qIA\b\u0001\u0004\tI%\u0001\u0004`Ef$Xm\u001d\t\u0006\u001d\u0005-\u0013qJ\u0005\u0004\u0003\u001bz!!\u0003$v]\u000e$\u0018n\u001c81!\u0011\t\t&!\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\n!![8\u000b\u0005)3\u0011\u0002BA.\u0003'\u0012\u0011c\u00115v].,GMQ=uK\n+hMZ3s\u0011\u001d\ty\u0006\u0001C\u0005\u0003C\n1\u0002];u\u0013R,'/\u0019;peV!\u00111MAF)1\t)'! \u0002\u0000\u00055\u00151SAK!\u0019\t9'a\u001eo]:!\u0011\u0011NA:\u001d\u0011\tY'!\u001d\u000e\u0005\u00055$bAA87\u00051AH]8pizJ\u0011\u0001E\u0005\u0004\u0003kz\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003s\nYH\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003kz\u0001bBA\u0007\u0003;\u0002\ra\u0014\u0005\t\u0003\u0003\u000bi\u00061\u0001\u0002\u0004\u00061a/\u00197vKN\u0004b!a\u001a\u0002\u0006\u0006%\u0015\u0002BAD\u0003w\u0012\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004/\u0006-EaBA\u001a\u0003;\u0012\r\u0001\u0018\u0005\t\u0003\u001f\u000bi\u00061\u0001\u0002\u0012\u0006A1\r\\1tgR\u000bw\r\u0005\u0004\u0002&\u0005-\u0012\u0011\u0012\u0005\t\u0003{\ti\u00061\u0001\u0002@!A\u0011qSA/\u0001\u0004\tI*\u0001\u0007wC2,Xm\u001d%pY\u0012,'\u000fE\u00039\u00037\u000bI)C\u0002\u0002\u001e\n\u0011ABV1mk\u0016\u001c\bj\u001c7eKJD\u0001\"!)\u0001\t\u0003!\u00111U\u0001\u0014aV$\u0018\n^3sCR|'/Q:WC2,Xm]\u000b\u0005\u0003K\u000b\t\f\u0006\u0005\u0002(\u0006M\u0016QWA]!\u001d\t9'a\u001e\u0002*:\u0004R\u0001OAV\u0003_K1!!,\u0003\u0005e\u0001\u0016M\u001d;jC2d\u00170\u00168s_2dW\rZ%uKJ\fGo\u001c:\u0011\u0007]\u000b\t\fB\u0004\u00024\u0005}%\u0019\u0001/\t\u000f\u00055\u0011q\u0014a\u0001\u001f\"A\u0011\u0011QAP\u0001\u0004\t9\f\u0005\u0004\u0002h\u0005\u0015\u0015q\u0016\u0005\t\u0003\u001f\u000by\n1\u0001\u0002<B1\u0011QEA\u0016\u0003_C\u0001\"a0\u0001\t\u0003!\u0011\u0011Y\u0001\u0013aV$\u0018\n^3sCR|'/Q:CsR,7/\u0006\u0003\u0002D\u0006=GCCAc\u0003#\f\u0019.a6\u0002\\B9\u0011qMA<\u0003\u000ft\u0007#\u0002\u001d\u0002J\u00065\u0017bAAf\u0005\tA\u0002+\u0019:uS\u0006dG._*fe&\fG.\u001b>fI\ncwnY6\u0011\u0007]\u000by\rB\u0004\u00024\u0005u&\u0019\u0001/\t\u000f\u00055\u0011Q\u0018a\u0001\u001f\"A\u0011\u0011QA_\u0001\u0004\t)\u000e\u0005\u0004\u0002h\u0005\u0015\u0015Q\u001a\u0005\t\u0003\u001f\u000bi\f1\u0001\u0002ZB1\u0011QEA\u0016\u0003\u001bD\u0001\"!\u0010\u0002>\u0002\u0007\u0011q\b\u0005\b\u0003?\u0004A\u0011AAq\u0003!9W\r\u001e\"zi\u0016\u001cH\u0003BAr\u0003S\u0004RADAs\u0003\u001fJ1!a:\u0010\u0005\u0019y\u0005\u000f^5p]\"9\u0011QBAo\u0001\u0004y\u0005bBAw\u0001\u0011\u0005\u0011q^\u0001\nO\u0016$h+\u00197vKN$B!!=\u0002~B)a\"!:\u0002tB\"\u0011Q_A}!\u0019\t9'!\"\u0002xB\u0019q+!?\u0005\u0017\u0005m\u00181^A\u0001\u0002\u0003\u0015\t\u0001\u0018\u0002\u0004?\u0012\u0012\u0004bBA\u0007\u0003W\u0004\ra\u0014\u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0003\u0019\u0011X-\\8wKR!\u0011\u0011\u0004B\u0003\u0011\u001d\ti!a@A\u0002=CqA!\u0003\u0001\t\u0003\u0011Y!A\u0003dY\u0016\f'\u000f\u0006\u0002\u0003\u000eA\u0019aBa\u0004\n\u0007\tEqB\u0001\u0003V]&$\bb\u0002B\u000b\u0001\u0011%!qC\u0001\tO\u0016$(\u000b\u001a3JIR!!\u0011\u0004B\u0011!\u0015q\u0011Q\u001dB\u000e!\rq!QD\u0005\u0004\u0005?y!aA%oi\"9\u0011Q\u0002B\n\u0001\u0004y\u0005\u0002\u0003B\u0013\u0001\u0011\u0005aAa\n\u0002-\u00154\u0018n\u0019;CY>\u001c7n\u001d+p\rJ,Wm\u00159bG\u0016$rA\u001cB\u0015\u0005[\u0011\t\u0004\u0003\u0005\u0002\u000e\t\r\u0002\u0019\u0001B\u0016!\u0011q\u0011Q](\t\u000f\t=\"1\u0005a\u0001]\u0006)1\u000f]1dK\"A\u0011Q\bB\u0012\u0001\u0004\ty\u0004C\u0004\u00036\u0001!\tBa\u000e\u0002\u001f\u00054G/\u001a:Ee>\u0004\u0018i\u0019;j_:$BA!\u0004\u0003:!9\u0011Q\u0002B\u001a\u0001\u0004y\u0005b\u0002B\u001f\u0001\u0011\u0005!qH\u0001\tG>tG/Y5ogR!\u0011\u0011\u0004B!\u0011\u001d\tiAa\u000fA\u0002=CqA!\u0012\u0001\t\u0013\u00119%\u0001\u000bdkJ\u0014XM\u001c;UCN\\\u0017\t\u001e;f[B$\u0018\n\u001a\u000b\u0002]\"9!1\n\u0001\u0005\u0002\t5\u0013A\b:fg\u0016\u0014h/Z+oe>dG.T3n_JLhi\u001c:UQ&\u001cH+Y:l)!\tIBa\u0014\u0003R\tM\u0003bBA\u0007\u0005\u0013\u0002\ra\u0014\u0005\u0007\u0007\t%\u0003\u0019\u00018\t\u0011\u0005u\"\u0011\na\u0001\u0003\u007fAqAa\u0016\u0001\t\u0003\u0011I&\u0001\u0010sK2,\u0017m]3V]J|G\u000e\\'f[>\u0014\u0018PR8s)\"L7\u000fV1tWR1!Q\u0002B.\u0005;B\u0001\"!\u0010\u0003V\u0001\u0007\u0011q\b\u0005\t\u0007\tU\u0003\u0013!a\u0001]\"1!\u0011\r\u0001\u0005\u0002e\f1cY;se\u0016tG/\u00168s_2dW*Z7pefDaA!\u001a\u0001\t\u0003I\u0018AH2veJ,g\u000e^+oe>dG.T3n_JLhi\u001c:UQ&\u001cH+Y:l\u0011\u001d\u0011I\u0007\u0001C\u0005\u0005W\n\u0011C\\;n)\u0006\u001c8n]+oe>dG.\u001b8h+\t\u0011Y\u0002C\u0004\u0003p\u0001!IAa\u0003\u0002\u001d1|w-T3n_JLXk]1hK\"9!1\u000f\u0001\u0005\n\tU\u0014a\u00067pOVs'o\u001c7m\r\u0006LG.\u001e:f\u001b\u0016\u001c8/Y4f)\u0019\u0011iAa\u001e\u0003z!9\u0011Q\u0002B9\u0001\u0004y\u0005b\u0002B>\u0005c\u0002\rA\\\u0001\u0010M&t\u0017\r\u001c,fGR|'oU5{K\"I!q\u0010\u0001\u0012\u0002\u0013\u0005!\u0011Q\u0001)e\u0016dW-Y:f+:\u0014x\u000e\u001c7NK6|'/\u001f$peRC\u0017n\u001d+bg.$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0007S3A\u001cBCW\t\u00119\t\u0005\u0003\u0003\n\nMUB\u0001BF\u0015\u0011\u0011iIa$\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BI\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU%1\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class MemoryStore
implements Logging {
    private final SparkConf conf;
    private final BlockInfoManager blockInfoManager;
    private final SerializerManager serializerManager;
    private final MemoryManager memoryManager;
    private final BlockEvictionHandler blockEvictionHandler;
    private final LinkedHashMap<BlockId, MemoryEntry<?>> entries;
    private final HashMap<Object, Object> onHeapUnrollMemoryMap;
    private final HashMap<Object, Object> offHeapUnrollMemoryMap;
    private final long unrollMemoryThreshold;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LinkedHashMap<BlockId, MemoryEntry<?>> entries() {
        return this.entries;
    }

    private HashMap<Object, Object> onHeapUnrollMemoryMap() {
        return this.onHeapUnrollMemoryMap;
    }

    private HashMap<Object, Object> offHeapUnrollMemoryMap() {
        return this.offHeapUnrollMemoryMap;
    }

    private long unrollMemoryThreshold() {
        return this.unrollMemoryThreshold;
    }

    private long maxMemory() {
        return this.memoryManager.maxOnHeapStorageMemory() + this.memoryManager.maxOffHeapStorageMemory();
    }

    private long memoryUsed() {
        return this.memoryManager.storageMemoryUsed();
    }

    private long blocksMemoryUsed() {
        long l;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            l = this.memoryUsed() - this.currentUnrollMemory();
        }
        return l;
    }

    public long getSize(BlockId blockId) {
        long l;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            l = this.entries().get(blockId).size();
        }
        return l;
    }

    public <T> boolean putBytes(BlockId blockId, long size, MemoryMode memoryMode, Function0<ChunkedByteBuffer> _bytes, ClassTag<T> evidence$2) {
        boolean bl;
        Predef$.MODULE$.require(!this.contains(blockId), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Block ").append(blockId).append(" is already present in the MemoryStore").toString());
        if (this.memoryManager.acquireStorageMemory(blockId, size, memoryMode)) {
            ChunkedByteBuffer bytes = (ChunkedByteBuffer)_bytes.apply();
            Predef$.MODULE$.assert(bytes.size() == size);
            SerializedMemoryEntry entry = new SerializedMemoryEntry(bytes, memoryMode, (ClassTag)Predef$.MODULE$.implicitly(evidence$2));
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                MemoryEntry cfr_ignored_0 = this.entries().put(blockId, entry);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Block %s stored as bytes in memory (estimated size %s, free %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blockId, Utils$.MODULE$.bytesToString(size), Utils$.MODULE$.bytesToString(this.maxMemory() - this.blocksMemoryUsed())})));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private <T> Either<Object, Object> putIterator(BlockId blockId, Iterator<T> values, ClassTag<T> classTag, MemoryMode memoryMode, ValuesHolder<T> valuesHolder) {
        Left left;
        Predef$.MODULE$.require(!this.contains(blockId), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Block ").append(blockId).append(" is already present in the MemoryStore").toString());
        int elementsUnrolled = 0;
        boolean keepUnrolling = true;
        long initialMemoryThreshold = this.unrollMemoryThreshold();
        long memoryCheckPeriod = BoxesRunTime.unboxToLong((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.UNROLL_MEMORY_CHECK_PERIOD()));
        long memoryThreshold = initialMemoryThreshold;
        double memoryGrowthFactor = BoxesRunTime.unboxToDouble((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.UNROLL_MEMORY_GROWTH_FACTOR()));
        long unrollMemoryUsedByThisBlock = 0L;
        keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, initialMemoryThreshold, memoryMode);
        if (!keepUnrolling) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to reserve initial memory threshold of ").append(new StringBuilder(32).append(Utils$.MODULE$.bytesToString(initialMemoryThreshold)).append(" for computing block ").append(blockId).append(" in memory.").toString()).toString());
        } else {
            unrollMemoryUsedByThisBlock += initialMemoryThreshold;
        }
        while (values.hasNext() && keepUnrolling) {
            long currentSize;
            valuesHolder.storeValue(values.next());
            if ((long)elementsUnrolled % memoryCheckPeriod == 0L && (currentSize = valuesHolder.estimatedSize()) >= memoryThreshold) {
                long amountToRequest = (long)((double)currentSize * memoryGrowthFactor - (double)memoryThreshold);
                keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, amountToRequest, memoryMode);
                if (keepUnrolling) {
                    unrollMemoryUsedByThisBlock += amountToRequest;
                }
                memoryThreshold += amountToRequest;
            }
            ++elementsUnrolled;
        }
        if (keepUnrolling) {
            long amountToRequest;
            MemoryEntryBuilder<T> entryBuilder = valuesHolder.getBuilder();
            long size = entryBuilder.preciseSize();
            if (size > unrollMemoryUsedByThisBlock && (keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, amountToRequest = size - unrollMemoryUsedByThisBlock, memoryMode))) {
                unrollMemoryUsedByThisBlock += amountToRequest;
            }
            if (keepUnrolling) {
                MemoryEntry entry = entryBuilder.build();
                MemoryManager memoryManager = this.memoryManager;
                synchronized (memoryManager) {
                    this.releaseUnrollMemoryForThisTask(memoryMode, unrollMemoryUsedByThisBlock);
                    boolean success = this.memoryManager.acquireStorageMemory(blockId, entry.size(), memoryMode);
                    Predef$.MODULE$.assert(success, (Function0 & Serializable & scala.Serializable)() -> "transferring unroll memory to storage memory failed");
                }
                LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
                synchronized (linkedHashMap) {
                    this.entries().put(blockId, entry);
                }
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Block %s stored as values in memory (estimated size %s, free %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blockId, Utils$.MODULE$.bytesToString(entry.size()), Utils$.MODULE$.bytesToString(this.maxMemory() - this.blocksMemoryUsed())})));
                left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)entry.size()));
            } else {
                this.logUnrollFailureMessage(blockId, entryBuilder.preciseSize());
                left = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToLong((long)unrollMemoryUsedByThisBlock));
            }
        } else {
            this.logUnrollFailureMessage(blockId, valuesHolder.estimatedSize());
            left = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToLong((long)unrollMemoryUsedByThisBlock));
        }
        return left;
    }

    public <T> Either<PartiallyUnrolledIterator<T>, Object> putIteratorAsValues(BlockId blockId, Iterator<T> values, ClassTag<T> classTag) {
        Right right;
        DeserializedValuesHolder<T> valuesHolder = new DeserializedValuesHolder<T>(classTag);
        Either<Object, Object> either = this.putIterator(blockId, values, classTag, MemoryMode.ON_HEAP, valuesHolder);
        if (either instanceof Right) {
            Right right2 = (Right)either;
            long storedSize = BoxesRunTime.unboxToLong((Object)right2.value());
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)storedSize));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            long unrollMemoryUsedByThisBlock = BoxesRunTime.unboxToLong((Object)left.value());
            Iterator unrolledIterator = valuesHolder.vector() != null ? valuesHolder.vector().iterator() : Predef$.MODULE$.genericArrayOps(valuesHolder.arrayValues()).toIterator();
            right = package$.MODULE$.Left().apply(new PartiallyUnrolledIterator<T>(this, MemoryMode.ON_HEAP, unrollMemoryUsedByThisBlock, unrolledIterator, values));
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    public <T> Either<PartiallySerializedBlock<T>, Object> putIteratorAsBytes(BlockId blockId, Iterator<T> values, ClassTag<T> classTag, MemoryMode memoryMode) {
        Right right;
        int n;
        Predef$.MODULE$.require(!this.contains(blockId), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Block ").append(blockId).append(" is already present in the MemoryStore").toString());
        long initialMemoryThreshold = this.unrollMemoryThreshold();
        if (initialMemoryThreshold > Integer.MAX_VALUE) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Initial memory threshold of ").append(Utils$.MODULE$.bytesToString(initialMemoryThreshold)).append(" ").append("is too large to be set as chunk size. Chunk size has been capped to ").append(String.valueOf(Utils$.MODULE$.bytesToString(Integer.MAX_VALUE))).toString());
            n = Integer.MAX_VALUE;
        } else {
            n = (int)initialMemoryThreshold;
        }
        int chunkSize = n;
        SerializedValuesHolder<T> valuesHolder = new SerializedValuesHolder<T>(blockId, chunkSize, classTag, memoryMode, this.serializerManager);
        Either<Object, Object> either = this.putIterator(blockId, values, classTag, memoryMode, valuesHolder);
        if (either instanceof Right) {
            Right right2 = (Right)either;
            long storedSize = BoxesRunTime.unboxToLong((Object)right2.value());
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)storedSize));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            long unrollMemoryUsedByThisBlock = BoxesRunTime.unboxToLong((Object)left.value());
            right = package$.MODULE$.Left().apply(new PartiallySerializedBlock<T>(this, this.serializerManager, blockId, valuesHolder.serializationStream(), valuesHolder.redirectableStream(), unrollMemoryUsedByThisBlock, memoryMode, valuesHolder.bbos(), values, classTag));
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    public Option<ChunkedByteBuffer> getBytes(BlockId blockId) {
        None$ none$;
        MemoryEntry<?> entry;
        MemoryEntry<?> memoryEntry;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            memoryEntry = this.entries().get(blockId);
        }
        MemoryEntry<?> memoryEntry2 = entry = memoryEntry;
        if (memoryEntry2 == null) {
            none$ = None$.MODULE$;
        } else {
            if (memoryEntry2 instanceof DeserializedMemoryEntry) {
                throw new IllegalArgumentException("should only call getBytes on serialized blocks");
            }
            if (memoryEntry2 instanceof SerializedMemoryEntry) {
                SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry2;
                ChunkedByteBuffer bytes = serializedMemoryEntry.buffer();
                none$ = new Some((Object)bytes);
            } else {
                throw new MatchError(memoryEntry2);
            }
        }
        return none$;
    }

    public Option<Iterator<?>> getValues(BlockId blockId) {
        None$ none$;
        MemoryEntry<?> entry;
        MemoryEntry<?> memoryEntry;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            memoryEntry = this.entries().get(blockId);
        }
        MemoryEntry<?> memoryEntry2 = entry = memoryEntry;
        if (memoryEntry2 == null) {
            none$ = None$.MODULE$;
        } else {
            if (memoryEntry2 instanceof SerializedMemoryEntry) {
                throw new IllegalArgumentException("should only call getValues on deserialized blocks");
            }
            if (memoryEntry2 instanceof DeserializedMemoryEntry) {
                DeserializedMemoryEntry deserializedMemoryEntry = (DeserializedMemoryEntry)memoryEntry2;
                Object values = deserializedMemoryEntry.value();
                Some x = new Some(values);
                none$ = x.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.genericArrayOps(x$1).iterator());
            } else {
                throw new MatchError(memoryEntry2);
            }
        }
        return none$;
    }

    public boolean remove(BlockId blockId) {
        boolean bl;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            boolean bl2;
            MemoryEntry memoryEntry;
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                memoryEntry = (MemoryEntry)this.entries().remove(blockId);
            }
            MemoryEntry entry = memoryEntry;
            if (entry != null) {
                MemoryEntry memoryEntry2 = entry;
                if (memoryEntry2 instanceof SerializedMemoryEntry) {
                    SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry2;
                    ChunkedByteBuffer buffer = serializedMemoryEntry.buffer();
                    buffer.dispose();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.memoryManager.releaseStorageMemory(entry.size(), entry.memoryMode());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Block ").append(blockId).append(" of size ").append(entry.size()).append(" dropped ").append(new StringBuilder(19).append("from memory (free ").append(this.maxMemory() - this.blocksMemoryUsed()).append(")").toString()).toString());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public void clear() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                this.entries().clear();
            }
            this.onHeapUnrollMemoryMap().clear();
            this.offHeapUnrollMemoryMap().clear();
            this.memoryManager.releaseAllStorageMemory();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "MemoryStore cleared");
        }
    }

    private Option<Object> getRddId(BlockId blockId) {
        return blockId.asRDDId().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.rddId()));
    }

    public long evictBlocksToFreeSpace(Option<BlockId> blockId2, long space, MemoryMode memoryMode) {
        long l;
        Predef$.MODULE$.assert(space > 0L);
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            long l2;
            LongRef freedMemory = LongRef.create((long)0L);
            Option rddToAdd = blockId2.flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.getRddId((BlockId)blockId));
            ArrayBuffer selectedBlocks = new ArrayBuffer();
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                java.util.Iterator<Map.Entry<BlockId, MemoryEntry<?>>> iterator = this.entries().entrySet().iterator();
                while (freedMemory.elem < space && iterator.hasNext()) {
                    MemoryEntry<?> entry;
                    Map.Entry<BlockId, MemoryEntry<?>> pair = iterator.next();
                    BlockId blockId3 = pair.getKey();
                    if (!this.blockIsEvictable$1(blockId3, entry = pair.getValue(), memoryMode, rddToAdd) || !this.blockInfoManager.lockForWriting(blockId3, false).isDefined()) continue;
                    selectedBlocks.$plus$eq((Object)blockId3);
                    freedMemory.elem += pair.getValue().size();
                }
            }
            if (freedMemory.elem >= space) {
                IntRef lastSuccessfulBlock = IntRef.create((int)-1);
                try {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append(selectedBlocks.size()).append(" blocks selected for dropping ").append(new StringBuilder(8).append("(").append(Utils$.MODULE$.bytesToString(freedMemory$1.elem)).append(" bytes)").toString()).toString());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), selectedBlocks.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                        MemoryEntry<?> memoryEntry;
                        BlockId blockId = (BlockId)selectedBlocks.apply(idx);
                        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
                        synchronized (linkedHashMap) {
                            memoryEntry = this.entries().get(blockId);
                        }
                        MemoryEntry<?> entry = memoryEntry;
                        if (entry != null) {
                            this.dropBlock$1(blockId, entry);
                            this.afterDropAction(blockId);
                        }
                        lastSuccessfulBlock$1.elem = idx;
                    });
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("After dropping ").append(selectedBlocks.size()).append(" blocks, ").append(new StringBuilder(15).append("free memory is ").append(Utils$.MODULE$.bytesToString(this.maxMemory() - this.blocksMemoryUsed())).toString()).toString());
                    l2 = freedMemory.elem;
                }
                finally {
                    if (lastSuccessfulBlock.elem != selectedBlocks.size() - 1) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(lastSuccessfulBlock.elem + 1), selectedBlocks.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                            BlockId blockId = (BlockId)selectedBlocks.apply(idx);
                            $this.blockInfoManager.unlock(blockId, $this.blockInfoManager.unlock$default$2());
                        });
                    }
                }
            } else {
                blockId2.foreach((Function1 & Serializable & scala.Serializable)id -> {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Will not store ").append(id).toString());
                    return BoxedUnit.UNIT;
                });
                selectedBlocks.foreach((Function1 & Serializable & scala.Serializable)id -> {
                    this.blockInfoManager.unlock(id, this.blockInfoManager.unlock$default$2());
                    return BoxedUnit.UNIT;
                });
                l2 = 0L;
            }
            l = l2;
        }
        return l;
    }

    public void afterDropAction(BlockId blockId) {
    }

    public boolean contains(BlockId blockId) {
        boolean bl;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            bl = this.entries().containsKey(blockId);
        }
        return bl;
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public boolean reserveUnrollMemoryForThisTask(BlockId blockId, long memory, MemoryMode memoryMode) {
        boolean bl;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            boolean success = this.memoryManager.acquireUnrollMemory(blockId, memory, memoryMode);
            if (success) {
                HashMap<Object, Object> hashMap;
                long taskAttemptId = this.currentTaskAttemptId();
                MemoryMode memoryMode2 = memoryMode;
                if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
                    hashMap = this.onHeapUnrollMemoryMap();
                } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
                    hashMap = this.offHeapUnrollMemoryMap();
                } else {
                    throw new MatchError((Object)memoryMode2);
                }
                HashMap<Object, Object> unrollMemoryMap = hashMap;
                unrollMemoryMap.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)unrollMemoryMap.getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + memory)));
            }
            bl = success;
        }
        return bl;
    }

    public void releaseUnrollMemoryForThisTask(MemoryMode memoryMode, long memory) {
        long taskAttemptId = this.currentTaskAttemptId();
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Object object;
            HashMap<Object, Object> hashMap;
            MemoryMode memoryMode2 = memoryMode;
            if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
                hashMap = this.onHeapUnrollMemoryMap();
            } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
                hashMap = this.offHeapUnrollMemoryMap();
            } else {
                throw new MatchError((Object)memoryMode2);
            }
            HashMap<Object, Object> unrollMemoryMap = hashMap;
            if (unrollMemoryMap.contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                long memoryToRelease = scala.math.package$.MODULE$.min(memory, BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))));
                if (memoryToRelease > 0L) {
                    unrollMemoryMap.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) - memoryToRelease)));
                    this.memoryManager.releaseUnrollMemory(memoryToRelease, memoryMode);
                }
                object = BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) == 0L ? unrollMemoryMap.remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public long releaseUnrollMemoryForThisTask$default$2() {
        return Long.MAX_VALUE;
    }

    public long currentUnrollMemory() {
        long l;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            l = BoxesRunTime.unboxToLong((Object)this.onHeapUnrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + BoxesRunTime.unboxToLong((Object)this.offHeapUnrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        return l;
    }

    public long currentUnrollMemoryForThisTask() {
        long l;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            l = BoxesRunTime.unboxToLong((Object)this.onHeapUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + BoxesRunTime.unboxToLong((Object)this.offHeapUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        }
        return l;
    }

    private int numTasksUnrolling() {
        int n;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            n = ((TraversableOnce)this.onHeapUnrollMemoryMap().keys().$plus$plus((GenTraversableOnce)this.offHeapUnrollMemoryMap().keys(), Iterable$.MODULE$.canBuildFrom())).toSet().size();
        }
        return n;
    }

    private void logMemoryUsage() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Memory use = ").append(Utils$.MODULE$.bytesToString(this.blocksMemoryUsed())).append(" (blocks) + ").append(new StringBuilder(30).append(Utils$.MODULE$.bytesToString(this.currentUnrollMemory())).append(" (scratch space shared across ").toString()).append(new StringBuilder(15).append(this.numTasksUnrolling()).append(" tasks(s)) = ").append(Utils$.MODULE$.bytesToString(this.memoryUsed())).append(". ").toString()).append(new StringBuilder(17).append("Storage limit = ").append(Utils$.MODULE$.bytesToString(this.maxMemory())).append(".").toString()).toString());
    }

    private void logUnrollFailureMessage(BlockId blockId, long finalVectorSize) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Not enough space to cache ").append(blockId).append(" in memory! ").append(new StringBuilder(18).append("(computed ").append(Utils$.MODULE$.bytesToString(finalVectorSize)).append(" so far)").toString()).toString());
        this.logMemoryUsage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean blockIsEvictable$1(BlockId blockId, MemoryEntry entry, MemoryMode memoryMode$1, Option rddToAdd$1) {
        MemoryMode memoryMode = entry.memoryMode();
        MemoryMode memoryMode2 = memoryMode$1;
        if (memoryMode == null) {
            if (memoryMode2 != null) {
                return false;
            }
        } else if (!((Object)((Object)memoryMode)).equals((Object)memoryMode2)) return false;
        if (rddToAdd$1.isEmpty()) return true;
        Option option = rddToAdd$1;
        Option<Object> option2 = this.getRddId(blockId);
        if (option == null) {
            if (option2 == null) return false;
            return true;
        } else if (option.equals(option2)) return false;
        return true;
    }

    public static final /* synthetic */ Either $anonfun$evictBlocksToFreeSpace$2(Either data$1) {
        return data$1;
    }

    private final void dropBlock$1(BlockId blockId, MemoryEntry entry) {
        Left left;
        MemoryEntry memoryEntry = entry;
        if (memoryEntry instanceof DeserializedMemoryEntry) {
            DeserializedMemoryEntry deserializedMemoryEntry = (DeserializedMemoryEntry)memoryEntry;
            Object values = deserializedMemoryEntry.value();
            left = package$.MODULE$.Left().apply(values);
        } else if (memoryEntry instanceof SerializedMemoryEntry) {
            SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry;
            ChunkedByteBuffer buffer = serializedMemoryEntry.buffer();
            left = package$.MODULE$.Right().apply((Object)buffer);
        } else {
            throw new MatchError((Object)memoryEntry);
        }
        Left data = left;
        StorageLevel newEffectiveStorageLevel = this.blockEvictionHandler.dropFromMemory(blockId, (Function0<Either<Object, ChunkedByteBuffer>>)((Function0 & Serializable & scala.Serializable)() -> MemoryStore.$anonfun$evictBlocksToFreeSpace$2((Either)data)), entry.classTag());
        if (newEffectiveStorageLevel.isValid()) {
            this.blockInfoManager.unlock(blockId, this.blockInfoManager.unlock$default$2());
        } else {
            this.blockInfoManager.removeBlock(blockId);
        }
    }

    public MemoryStore(SparkConf conf, BlockInfoManager blockInfoManager, SerializerManager serializerManager, MemoryManager memoryManager, BlockEvictionHandler blockEvictionHandler) {
        this.conf = conf;
        this.blockInfoManager = blockInfoManager;
        this.serializerManager = serializerManager;
        this.memoryManager = memoryManager;
        this.blockEvictionHandler = blockEvictionHandler;
        Logging.$init$(this);
        this.entries = new LinkedHashMap(32, 0.75f, true);
        this.onHeapUnrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.offHeapUnrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.unrollMemoryThreshold = conf.getLong("spark.storage.unrollMemoryThreshold", 0x100000L);
        if (this.maxMemory() < this.unrollMemoryThreshold()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Max memory ").append(Utils$.MODULE$.bytesToString(this.maxMemory())).append(" is less than the initial memory ").append(new StringBuilder(38).append("threshold ").append(Utils$.MODULE$.bytesToString(this.unrollMemoryThreshold())).append(" needed to store a block in ").toString()).append("memory. Please configure Spark with more memory.").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("MemoryStore started with capacity %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.maxMemory())})));
    }
}

