/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskFailedReason;
import org.apache.spark.TaskResultLost$;
import org.apache.spark.TaskState$;
import org.apache.spark.UnknownReason$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.DirectTaskResult;
import org.apache.spark.scheduler.IndirectTaskResult;
import org.apache.spark.scheduler.TaskResult;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=a!B\u0001\u0003\u0001\u0011Q!\u0001\u0005+bg.\u0014Vm];mi\u001e+G\u000f^3s\u0015\t\u0019A!A\u0005tG\",G-\u001e7fe*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\tgB\f'o[#om\u000e\u0001\u0001CA\u000e\u001d\u001b\u0005!\u0011BA\u000f\u0005\u0005!\u0019\u0006/\u0019:l\u000b:4\b\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!\u0005+bg.\u001c6\r[3ek2,'/S7qY\")A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"2AJ\u0014)!\t\u0001\u0003\u0001C\u0003\u0019G\u0001\u0007!\u0004C\u0003\u0004G\u0001\u0007q\u0004C\u0004+\u0001\t\u0007I\u0011B\u0016\u0002\u000fQC%+R!E'V\tA\u0006\u0005\u0002\r[%\u0011a&\u0004\u0002\u0004\u0013:$\bB\u0002\u0019\u0001A\u0003%A&\u0001\u0005U\u0011J+\u0015\tR*!\u0011\u001d\u0011\u0004A1A\u0005\u0012M\nQcZ3u)\u0006\u001c8NU3tk2$X\t_3dkR|'/F\u00015!\t)D(D\u00017\u0015\t9\u0004(\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u000f\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0002w\u0005!!.\u0019<b\u0013\tidGA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u0019y\u0004\u0001)A\u0005i\u00051r-\u001a;UCN\\'+Z:vYR,\u00050Z2vi>\u0014\b\u0005C\u0004B\u0001\t\u0007I\u0011\u0003\"\u0002\u0015M,'/[1mSj,'/F\u0001D!\r!u)S\u0007\u0002\u000b*\u0011aIO\u0001\u0005Y\u0006tw-\u0003\u0002I\u000b\nYA\u000b\u001b:fC\u0012dunY1m!\tQE*D\u0001L\u0015\t\tE!\u0003\u0002N\u0017\n\u00112+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011\u0019y\u0005\u0001)A\u0005\u0007\u0006Y1/\u001a:jC2L'0\u001a:!\u0011\u001d\t\u0006A1A\u0005\u0012\t\u000bA\u0003^1tWJ+7/\u001e7u'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bBB*\u0001A\u0003%1)A\u000buCN\\'+Z:vYR\u001cVM]5bY&TXM\u001d\u0011\t\u000bU\u0003A\u0011\u0001,\u0002+\u0015t\u0017/^3vKN+8mY3tg\u001a,H\u000eV1tWR!qKW0e!\ta\u0001,\u0003\u0002Z\u001b\t!QK\\5u\u0011\u0015YF\u000b1\u0001]\u00039!\u0018m]6TKRl\u0015M\\1hKJ\u0004\"\u0001I/\n\u0005y\u0013!A\u0004+bg.\u001cV\r^'b]\u0006<WM\u001d\u0005\u0006AR\u0003\r!Y\u0001\u0004i&$\u0007C\u0001\u0007c\u0013\t\u0019WB\u0001\u0003M_:<\u0007\"B3U\u0001\u00041\u0017AD:fe&\fG.\u001b>fI\u0012\u000bG/\u0019\t\u0003O*l\u0011\u0001\u001b\u0006\u0003Sj\n1A\\5p\u0013\tY\u0007N\u0001\u0006CsR,')\u001e4gKJDQ!\u001c\u0001\u0005\u00029\f\u0011#\u001a8rk\u0016,XMR1jY\u0016$G+Y:l)\u00199v\u000e]9\u0002\b!)1\f\u001ca\u00019\")\u0001\r\u001ca\u0001C\")!\u000f\u001ca\u0001g\u0006IA/Y:l'R\fG/\u001a\t\u0004i\u0006\u0005aBA;\u007f\u001d\t1XP\u0004\u0002xy:\u0011\u0001p_\u0007\u0002s*\u0011!0G\u0001\u0007yI|w\u000e\u001e \n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011BA@\u0005\u0003%!\u0016m]6Ti\u0006$X-\u0003\u0003\u0002\u0004\u0005\u0015!!\u0003+bg.\u001cF/\u0019;f\u0015\tyH\u0001C\u0003fY\u0002\u0007a\rC\u0004\u0002\f\u0001!\t!!\u0004\u0002\tM$x\u000e\u001d\u000b\u0002/\u0002")
public class TaskResultGetter
implements Logging {
    public final SparkEnv org$apache$spark$scheduler$TaskResultGetter$$sparkEnv;
    public final TaskSchedulerImpl org$apache$spark$scheduler$TaskResultGetter$$scheduler;
    private final int THREADS;
    private final ExecutorService getTaskResultExecutor;
    private final ThreadLocal<SerializerInstance> serializer;
    private final ThreadLocal<SerializerInstance> taskResultSerializer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int THREADS() {
        return this.THREADS;
    }

    public ExecutorService getTaskResultExecutor() {
        return this.getTaskResultExecutor;
    }

    public ThreadLocal<SerializerInstance> serializer() {
        return this.serializer;
    }

    public ThreadLocal<SerializerInstance> taskResultSerializer() {
        return this.taskResultSerializer;
    }

    public void enqueueSuccessfulTask(TaskSetManager taskSetManager, long tid, ByteBuffer serializedData) {
        this.getTaskResultExecutor().execute(new Runnable(this, taskSetManager, tid, serializedData){
            private final /* synthetic */ TaskResultGetter $outer;
            private final TaskSetManager taskSetManager$1;
            private final long tid$1;
            private final ByteBuffer serializedData$1;

            public void run() {
                Object object = new Object();
                try {
                    Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        try {
                            Tuple2 tuple2;
                            TaskResult taskResult = (TaskResult)$this.$outer.serializer().get().deserialize($this.serializedData$1, ClassTag$.MODULE$.apply(TaskResult.class));
                            if (taskResult instanceof DirectTaskResult) {
                                DirectTaskResult directTaskResult = (DirectTaskResult)taskResult;
                                if (!$this.taskSetManager$1.canFetchMoreResults($this.serializedData$1.limit())) {
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                                directTaskResult.value($this.$outer.taskResultSerializer().get());
                                tuple2 = new Tuple2((Object)directTaskResult, (Object)BoxesRunTime.boxToInteger((int)$this.serializedData$1.limit()));
                            } else if (taskResult instanceof IndirectTaskResult) {
                                IndirectTaskResult indirectTaskResult = (IndirectTaskResult)taskResult;
                                BlockId blockId = indirectTaskResult.blockId();
                                int size = indirectTaskResult.size();
                                if (!$this.taskSetManager$1.canFetchMoreResults(size)) {
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                                $this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Fetching indirect task result for TID %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)$this.tid$1)})));
                                $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleTaskGettingResult($this.taskSetManager$1, $this.tid$1);
                                Option<ChunkedByteBuffer> serializedTaskResult = $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().getRemoteBytes(blockId);
                                if (!serializedTaskResult.isDefined()) {
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask($this.taskSetManager$1, $this.tid$1, TaskState$.MODULE$.FINISHED(), TaskResultLost$.MODULE$);
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                                DirectTaskResult deserializedResult = (DirectTaskResult)$this.$outer.serializer().get().deserialize(((ChunkedByteBuffer)serializedTaskResult.get()).toByteBuffer(), ClassTag$.MODULE$.apply(DirectTaskResult.class));
                                deserializedResult.value($this.$outer.taskResultSerializer().get());
                                $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                tuple2 = new Tuple2((Object)deserializedResult, (Object)BoxesRunTime.boxToInteger((int)size));
                            } else {
                                throw new MatchError((Object)taskResult);
                            }
                            Tuple2 tuple22 = tuple2;
                            if (tuple22 == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            DirectTaskResult result = (DirectTaskResult)tuple22._1();
                            int size = tuple22._2$mcI$sp();
                            Tuple2 tuple23 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToInteger((int)size));
                            Tuple2 tuple24 = tuple23;
                            DirectTaskResult result2 = (DirectTaskResult)tuple24._1();
                            int size2 = tuple24._2$mcI$sp();
                            result2.accumUpdates_$eq((Seq)result2.accumUpdates().map((Function1 & Serializable & scala.Serializable)a -> {
                                AccumulatorV2 accumulatorV2;
                                Option<String> option = a.name();
                                Some some = new Some((Object)InternalAccumulator$.MODULE$.RESULT_SIZE());
                                if (!(option != null ? !option.equals((Object)some) : some != null)) {
                                    void var3_3;
                                    LongAccumulator acc = (LongAccumulator)a;
                                    Predef$.MODULE$.assert(acc.sum() == 0L, (Function0 & Serializable & scala.Serializable)() -> "task result size should not have been set on the executors");
                                    acc.setValue(size2);
                                    accumulatorV2 = var3_3;
                                } else {
                                    accumulatorV2 = a;
                                }
                                return accumulatorV2;
                            }, Seq$.MODULE$.canBuildFrom()));
                            $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleSuccessfulTask($this.taskSetManager$1, $this.tid$1, result2);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof ClassNotFoundException) {
                                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                                $this.taskSetManager$1.abort(new StringBuilder(32).append("ClassNotFound with classloader: ").append(loader).toString(), $this.taskSetManager$1.abort$default$2());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable ex = (Throwable)option.get();
                                $this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while getting task result", ex);
                                $this.taskSetManager$1.abort(new StringOps(Predef$.MODULE$.augmentString("Exception while getting task result: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ex})), $this.taskSetManager$1.abort$default$2());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            throw throwable;
                        }
                    });
                }
                catch (NonLocalReturnControl ex) {
                    if (ex.key() == object) {
                        ex.value$mcV$sp();
                    }
                    throw ex;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskSetManager$1 = taskSetManager$1;
                this.tid$1 = tid$1;
                this.serializedData$1 = serializedData$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.TaskResultGetter$$anon$3 java.lang.Object ), $anonfun$run$4(), $anonfun$run$2(org.apache.spark.scheduler.TaskResultGetter$$anon$3 ), $anonfun$run$3(int org.apache.spark.util.AccumulatorV2 ), $anonfun$run$5()}, serializedLambda);
            }
        });
    }

    public void enqueueFailedTask(TaskSetManager taskSetManager, long tid, Enumeration.Value taskState, ByteBuffer serializedData) {
        ObjectRef reason = ObjectRef.create((Object)UnknownReason$.MODULE$);
        try {
            this.getTaskResultExecutor().execute(new Runnable(this, taskSetManager, tid, taskState, serializedData, reason){
                private final /* synthetic */ TaskResultGetter $outer;
                private final TaskSetManager taskSetManager$2;
                private final long tid$2;
                private final Enumeration.Value taskState$1;
                private final ByteBuffer serializedData$2;
                private final ObjectRef reason$1;

                public void run() {
                    Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
                        try {
                            try {
                                if ($this.serializedData$2 != null && $this.serializedData$2.limit() > 0) {
                                    $this.reason$1.elem = (TaskFailedReason)$this.$outer.serializer().get().deserialize($this.serializedData$2, loader, ClassTag$.MODULE$.apply(TaskFailedReason.class));
                                }
                            }
                            catch (ClassNotFoundException cnd) {
                                $this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Could not deserialize TaskEndReason: ClassNotFound with classloader ").append(loader).toString());
                            }
                            catch (Exception exception) {}
                        }
                        finally {
                            $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask($this.taskSetManager$2, $this.tid$2, $this.taskState$1, (TaskFailedReason)$this.reason$1.elem);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.taskSetManager$2 = taskSetManager$2;
                    this.tid$2 = tid$2;
                    this.taskState$1 = taskState$1;
                    this.serializedData$2 = serializedData$2;
                    this.reason$1 = reason$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$6(org.apache.spark.scheduler.TaskResultGetter$$anon$4 ), $anonfun$run$7(java.lang.ClassLoader )}, serializedLambda);
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RejectedExecutionException && this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.isStopped()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void stop() {
        this.getTaskResultExecutor().shutdownNow();
    }

    public TaskResultGetter(SparkEnv sparkEnv, TaskSchedulerImpl scheduler) {
        this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv = sparkEnv;
        this.org$apache$spark$scheduler$TaskResultGetter$$scheduler = scheduler;
        Logging.$init$(this);
        this.THREADS = sparkEnv.conf().getInt("spark.resultGetter.threads", 4);
        this.getTaskResultExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.THREADS(), "task-result-getter");
        this.serializer = new ThreadLocal<SerializerInstance>(this){
            private final /* synthetic */ TaskResultGetter $outer;

            public SerializerInstance initialValue() {
                return this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.closureSerializer().newInstance();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.taskResultSerializer = new ThreadLocal<SerializerInstance>(this){
            private final /* synthetic */ TaskResultGetter $outer;

            public SerializerInstance initialValue() {
                return this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.serializer().newInstance();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

