/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u00055h!B\u0001\u0003\u0001\u0019a!!\u0007(fiRL(\t\\8dWR\u0013\u0018M\\:gKJ\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u00028fi^|'o\u001b\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001d=i\u0011\u0001B\u0005\u0003!\u0011\u0011AC\u00117pG.$&/\u00198tM\u0016\u00148+\u001a:wS\u000e,\u0007\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\t\r|gNZ\u0002\u0001!\t)b#D\u0001\u0007\u0013\t9bAA\u0005Ta\u0006\u00148nQ8oM\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\t)2$\u0003\u0002\u001d\r\ty1+Z2ve&$\u00180T1oC\u001e,'\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003-\u0011\u0017N\u001c3BI\u0012\u0014Xm]:\u0011\u0005\u0001JcBA\u0011(!\t\u0011S%D\u0001$\u0015\t!3#\u0001\u0004=e>|GO\u0010\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&J\u0001\u0007!J,G-\u001a4\n\u0005)Z#AB*ue&twM\u0003\u0002)K!AQ\u0006\u0001BC\u0002\u0013\u0005c&\u0001\u0005i_N$h*Y7f+\u0005y\u0002\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u0013!|7\u000f\u001e(b[\u0016\u0004\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u000b}\u0003xN\u001d;\u0011\u0005Q*T\"A\u0013\n\u0005Y*#aA%oi\"A\u0001\b\u0001B\u0001B\u0003%1'\u0001\u0005ok6\u001cuN]3t\u0011\u0015Q\u0004\u0001\"\u0001<\u0003\u0019a\u0014N\\5u}Q9AHP A\u0003\n\u001b\u0005CA\u001f\u0001\u001b\u0005\u0011\u0001\"\u0002\n:\u0001\u0004!\u0002\"B\r:\u0001\u0004Q\u0002\"\u0002\u0010:\u0001\u0004y\u0002\"B\u0017:\u0001\u0004y\u0002\"\u0002\u001a:\u0001\u0004\u0019\u0004\"\u0002\u001d:\u0001\u0004\u0019\u0004bB#\u0001\u0005\u0004%IAR\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014X#A$\u0011\u0005!SU\"A%\u000b\u0005\u00153\u0011BA&J\u00059Q\u0015M^1TKJL\u0017\r\\5{KJDa!\u0014\u0001!\u0002\u00139\u0015aC:fe&\fG.\u001b>fe\u0002Bqa\u0014\u0001C\u0002\u0013%\u0001+A\u0006bkRDWI\\1cY\u0016$W#A)\u0011\u0005Q\u0012\u0016BA*&\u0005\u001d\u0011un\u001c7fC:Da!\u0016\u0001!\u0002\u0013\t\u0016\u0001D1vi\",e.\u00192mK\u0012\u0004\u0003bB,\u0001\u0005\u0004%I\u0001W\u0001\u000eiJ\fgn\u001d9peR\u001cuN\u001c4\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001\u0018\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003=n\u0013Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0007B\u00021\u0001A\u0003%\u0011,\u0001\bue\u0006t7\u000f]8si\u000e{gN\u001a\u0011\t\u0013\t\u0004\u0001\u0019!A!B\u0013\u0019\u0017\u0001\u0005;sC:\u001c\bo\u001c:u\u0007>tG/\u001a=u!\tqA-\u0003\u0002f\t\t\u0001BK]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\u0005\nO\u0002\u0001\r\u0011!Q!\n!\faa]3sm\u0016\u0014\bCA5l\u001b\u0005Q'BA4\u0005\u0013\ta'NA\bUe\u0006t7\u000f]8siN+'O^3s\u0011%q\u0007\u00011A\u0001B\u0003&q.A\u0007dY&,g\u000e\u001e$bGR|'/\u001f\t\u0003aNl\u0011!\u001d\u0006\u0003e\u0012\taa\u00197jK:$\u0018B\u0001;r\u0005Y!&/\u00198ta>\u0014Ho\u00117jK:$h)Y2u_JL\b\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003 \u0003\u0015\t\u0007\u000f]%e\u0011\u0015A\b\u0001\"\u0011z\u0003\u0011Ig.\u001b;\u0015\u0005il\bC\u0001\u001b|\u0013\taXE\u0001\u0003V]&$\b\"\u0002@x\u0001\u0004y\u0018\u0001\u00052m_\u000e\\G)\u0019;b\u001b\u0006t\u0017mZ3s!\rq\u0011\u0011A\u0005\u0004\u0003\u0007!!\u0001\u0005\"m_\u000e\\G)\u0019;b\u001b\u0006t\u0017mZ3s\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013\tAb\u0019:fCR,7+\u001a:wKJ$2\u0001[A\u0006\u0011!\ti!!\u0002A\u0002\u0005=\u0011A\u00032p_R\u001cHO]1qgB1\u0011\u0011CA\u000e\u0003CqA!a\u0005\u0002\u00189\u0019!%!\u0006\n\u0003\u0019J1!!\u0007&\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\b\u0002 \t!A*[:u\u0015\r\tI\"\n\t\u0004S\u0006\r\u0012bAA\u0013U\nABK]1ogB|'\u000f^*feZ,'OQ8piN$(/\u00199\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,\u0005q1\u000f[;gM2,W*\u001a;sS\u000e\u001cHCAA\u0017!\u0011\ty#!\u0010\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\tq!\\3ue&\u001c7O\u0003\u0003\u00028\u0005e\u0012\u0001C2pI\u0006D\u0017\r\\3\u000b\u0005\u0005m\u0012aA2p[&!\u0011qHA\u0019\u0005%iU\r\u001e:jGN+G\u000fC\u0004\u0002D\u0001!\t%!\u0012\u0002\u0017\u0019,Go\u00195CY>\u001c7n\u001d\u000b\u000eu\u0006\u001d\u00131JA(\u0003'\ni&!\u001c\t\u000f\u0005%\u0013\u0011\ta\u0001?\u0005!\u0001n\\:u\u0011\u001d\ti%!\u0011A\u0002M\nA\u0001]8si\"9\u0011\u0011KA!\u0001\u0004y\u0012AB3yK\u000eLE\r\u0003\u0005\u0002V\u0005\u0005\u0003\u0019AA,\u0003!\u0011Gn\\2l\u0013\u0012\u001c\b\u0003\u0002\u001b\u0002Z}I1!a\u0017&\u0005\u0015\t%O]1z\u0011!\ty&!\u0011A\u0002\u0005\u0005\u0014\u0001\u00037jgR,g.\u001a:\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a\u0005\u0003\u001d\u0019\b.\u001e4gY\u0016LA!a\u001b\u0002f\t)\"\t\\8dW\u001a+Go\u00195j]\u001ed\u0015n\u001d;f]\u0016\u0014\b\u0002CA8\u0003\u0003\u0002\r!!\u001d\u0002\u001fQ,W\u000e\u001d$jY\u0016l\u0015M\\1hKJ\u0004B!a\u0019\u0002t%!\u0011QOA3\u0005M!un\u001e8m_\u0006$g)\u001b7f\u001b\u0006t\u0017mZ3s\u0011\u001d\ti\u0005\u0001C!\u0003s*\u0012a\r\u0005\b\u0003{\u0002A\u0011IA@\u0003-)\b\u000f\\8bI\ncwnY6\u0015!\u0005\u0005\u0015QRAI\u0003'\u000b)*!*\u00026\u0006}\u0006#BAB\u0003\u0013SXBAAC\u0015\r\t9)J\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAF\u0003\u000b\u0013aAR;ukJ,\u0007bBAH\u0003w\u0002\raH\u0001\tQ>\u001cHO\\1nK\"9\u0011QJA>\u0001\u0004\u0019\u0004bBA)\u0003w\u0002\ra\b\u0005\t\u0003/\u000bY\b1\u0001\u0002\u001a\u00069!\r\\8dW&#\u0007\u0003BAN\u0003Ck!!!(\u000b\u0007\u0005}e!A\u0004ti>\u0014\u0018mZ3\n\t\u0005\r\u0016Q\u0014\u0002\b\u00052|7m[%e\u0011!\t9+a\u001fA\u0002\u0005%\u0016!\u00032m_\u000e\\G)\u0019;b!\u0011\tY+!-\u000e\u0005\u00055&bAAX\t\u00051!-\u001e4gKJLA!a-\u0002.\niQ*\u00198bO\u0016$')\u001e4gKJD\u0001\"a.\u0002|\u0001\u0007\u0011\u0011X\u0001\u0006Y\u00164X\r\u001c\t\u0005\u00037\u000bY,\u0003\u0003\u0002>\u0006u%\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\u0002CAa\u0003w\u0002\r!a1\u0002\u0011\rd\u0017m]:UC\u001e\u0004D!!2\u0002VB1\u0011qYAg\u0003#l!!!3\u000b\u0007\u0005-W%A\u0004sK\u001adWm\u0019;\n\t\u0005=\u0017\u0011\u001a\u0002\t\u00072\f7o\u001d+bOB!\u00111[Ak\u0019\u0001!A\"a6\u0002@\u0006\u0005\t\u0011!B\u0001\u00033\u00141a\u0018\u00132#\u0011\tY.!9\u0011\u0007Q\ni.C\u0002\u0002`\u0016\u0012qAT8uQ&tw\rE\u00025\u0003GL1!!:&\u0005\r\te.\u001f\u0005\b\u0003S\u0004A\u0011IAv\u0003\u0015\u0019Gn\\:f)\u0005Q\b")
public class NettyBlockTransferService
extends BlockTransferService {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String bindAddress;
    private final String hostName;
    private final int _port;
    private final JavaSerializer serializer;
    private final boolean authEnabled;
    private final TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;
    public TransportClientFactory org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory;
    public String org$apache$spark$network$netty$NettyBlockTransferService$$appId;

    @Override
    public String hostName() {
        return this.hostName;
    }

    private JavaSerializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    public TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new AuthServerBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new AuthClientBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.conf.getAppId(), (SecretKeyHolder)this.securityManager));
        }
        this.transportContext = new TransportContext(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (RpcHandler)rpcHandler);
        this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory = this.transportContext.createClientFactory((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$appId = this.conf.getAppId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Server created on ").append(this.hostName()).append(":").append($this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort()).toString());
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(this._port, (Function1 & Serializable & scala.Serializable)port -> this.startService$1(BoxesRunTime.unboxToInt((Object)port), bootstraps), this.conf, this.getClass().getName())._1();
    }

    public MetricSet shuffleMetrics() {
        Predef$.MODULE$.require(this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null && this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory != null, (Function0 & Serializable & scala.Serializable)() -> "NettyBlockTransferServer is not initialized");
        return new MetricSet(this){
            private final HashMap<String, Metric> allMetrics;
            private final /* synthetic */ NettyBlockTransferService $outer;

            private HashMap<String, Metric> allMetrics() {
                return this.allMetrics;
            }

            public Map<String, Metric> getMetrics() {
                this.allMetrics().putAll(this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.getAllMetrics().getMetrics());
                this.allMetrics().putAll(this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getAllMetrics().getMetrics());
                return this.allMetrics();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allMetrics = new HashMap<K, V>();
            }
        };
    }

    @Override
    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, DownloadFileManager tempFileManager) {
        block3: {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Fetch blocks from ").append(host).append(":").append(port).append(" (executor id ").append(execId).append(")").toString());
            try {
                RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = new RetryingBlockFetcher.BlockFetchStarter(this, host, port, execId, tempFileManager){
                    private final /* synthetic */ NettyBlockTransferService $outer;
                    private final String host$1;
                    private final int port$1;
                    private final String execId$1;
                    private final DownloadFileManager tempFileManager$1;

                    public void createAndStart(String[] blockIds, BlockFetchingListener listener) {
                        TransportClient client = this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(this.host$1, this.port$1);
                        new OneForOneBlockFetcher(client, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$appId, this.execId$1, blockIds, listener, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.tempFileManager$1).start();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.host$1 = host$1;
                        this.port$1 = port$1;
                        this.execId$1 = execId$1;
                        this.tempFileManager$1 = tempFileManager$1;
                    }
                };
                int maxRetries = this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf().maxIORetries();
                if (maxRetries > 0) {
                    new RetryingBlockFetcher(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), blockFetchStarter, blockIds, listener).start();
                    break block3;
                }
                blockFetchStarter.createAndStart(blockIds, listener);
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while beginning fetchBlocks", e);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    listener.onBlockFetchFailure(x$1, (Throwable)e);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        long l;
        Promise result = Promise$.MODULE$.apply();
        TransportClient client = this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        boolean asStream = blockData.size() > BoxesRunTime.unboxToLong((Object)this.conf.get(package$.MODULE$.MAX_REMOTE_BLOCK_SIZE_FETCH_TO_MEM()));
        RpcResponseCallback callback = new RpcResponseCallback(this, blockId, result, asStream){
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final BlockId blockId$1;
            private final Promise result$1;
            private final boolean asStream$1;

            public void onSuccess(ByteBuffer response) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Successfully uploaded block ").append($this.blockId$1).append((Object)($this.asStream$1 ? " as stream" : "")).toString());
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error while uploading ").append($this.blockId$1).append((Object)($this.asStream$1 ? " as stream" : "")).toString(), e);
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.result$1 = result$1;
                this.asStream$1 = asStream$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onSuccess$1(org.apache.spark.network.netty.NettyBlockTransferService$$anon$3 ), $anonfun$onFailure$1(org.apache.spark.network.netty.NettyBlockTransferService$$anon$3 )}, serializedLambda);
            }
        };
        if (asStream) {
            ByteBuffer streamHeader = new UploadBlockStream(blockId.name(), metadata).toByteBuffer();
            l = client.uploadStream((ManagedBuffer)new NioManagedBuffer(streamHeader), blockData, callback);
        } else {
            byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
            l = client.sendRpc(new UploadBlock(this.org$apache$spark$network$netty$NettyBlockTransferService$$appId, execId, blockId.name(), metadata, array).toByteBuffer(), callback);
        }
        return result.future();
    }

    @Override
    public void close() {
        block1: {
            if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
                this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
            }
            if (this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory == null) break block1;
            this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.close();
        }
    }

    private final Tuple2 startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.bindAddress, port, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, String bindAddress, String hostName, int _port, int numCores) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.bindAddress = bindAddress;
        this.hostName = hostName;
        this._port = _port;
        this.serializer = new JavaSerializer(conf);
        this.authEnabled = securityManager.isAuthenticationEnabled();
        this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", numCores);
    }
}

