/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearch.model.transform;

import com.amazonaws.services.cloudsearch.model.SourceData;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceDataStaxUnmarshaller
implements Unmarshaller<SourceData, StaxUnmarshallerContext> {
    private static SourceDataStaxUnmarshaller instance;

    @Override
    public SourceData unmarshall(StaxUnmarshallerContext context) throws Exception {
        SourceData sourceData = new SourceData();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return sourceData;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceName", targetDepth)) {
                    sourceData.setSourceName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DefaultValue", targetDepth)) continue;
                sourceData.setDefaultValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return sourceData;
    }

    public static SourceDataStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SourceDataStaxUnmarshaller();
        }
        return instance;
    }
}

