/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant.fieldtype;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.fieldtype.FieldValue;

public class FieldValueCreator
extends Creator<FieldValue> {
    private final String pathAssistantSid;
    private final String pathFieldTypeSid;
    private final String language;
    private final String value;
    private String synonymOf;

    public FieldValueCreator(String pathAssistantSid, String pathFieldTypeSid, String language, String value) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathFieldTypeSid = pathFieldTypeSid;
        this.language = language;
        this.value = value;
    }

    public FieldValueCreator setSynonymOf(String synonymOf) {
        this.synonymOf = synonymOf;
        return this;
    }

    @Override
    public FieldValue create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/FieldTypes/" + this.pathFieldTypeSid + "/FieldValues", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FieldValue creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return FieldValue.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.language != null) {
            request.addPostParam("Language", this.language);
        }
        if (this.value != null) {
            request.addPostParam("Value", this.value);
        }
        if (this.synonymOf != null) {
            request.addPostParam("SynonymOf", this.synonymOf.toString());
        }
    }
}

