/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.bulkExports;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.bulkExports.ExportConfiguration;

public class ExportConfigurationFetcher
extends Fetcher<ExportConfiguration> {
    private final String pathResourceType;

    public ExportConfigurationFetcher(String pathResourceType) {
        this.pathResourceType = pathResourceType;
    }

    @Override
    public ExportConfiguration fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/BulkExports/Exports/" + this.pathResourceType + "/Configuration", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExportConfiguration fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return ExportConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }
}

