/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.google.common.collect.Lists;
import com.twilio.Twilio;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpClient;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.ValidationInterceptor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class ValidationClient
extends HttpClient {
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 30500;
    private final org.apache.http.client.HttpClient client;

    public ValidationClient(String accountSid, String credentialSid, String signingKey, PrivateKey privateKey) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30500).build();
        ArrayList<Header> headers = Lists.newArrayList(new BasicHeader("X-Twilio-Client", "java-7.34.1"), new BasicHeader("User-Agent", "twilio-java/7.34.1 (" + Twilio.JAVA_VERSION + ")"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "utf-8"));
        this.client = HttpClientBuilder.create().setConnectionManager(new PoolingHttpClientConnectionManager()).setDefaultRequestConfig(config).setDefaultHeaders(headers).setMaxConnPerRoute(10).addInterceptorLast(new ValidationInterceptor(accountSid, credentialSid, signingKey, privateKey)).build();
    }

    @Override
    public Response makeRequest(Request request) {
        HttpMethod method;
        RequestBuilder builder = RequestBuilder.create(request.getMethod().toString()).setUri(request.constructURL().toString()).setVersion(HttpVersion.HTTP_1_1).setCharset(StandardCharsets.UTF_8);
        if (request.requiresAuthentication()) {
            builder.addHeader("Authorization", request.getAuthString());
        }
        if ((method = request.getMethod()) == HttpMethod.POST) {
            builder.addHeader("Content-Type", "application/x-www-form-urlencoded");
            for (Map.Entry<String, List<String>> entry : request.getPostParams().entrySet()) {
                for (String value : entry.getValue()) {
                    builder.addParameter(entry.getKey(), value);
                }
            }
        }
        try {
            HttpResponse response = this.client.execute(builder.build());
            return new Response(response.getEntity() == null ? null : response.getEntity().getContent(), response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }
}

